package com.install4j.api.beaninfo;

import java.awt.*;

/**
 * Extended design-time services for customizers. Implement this interface
 * in your customizer class to have the install4j GUI call its methods at design-time.
 * @see Install4JBeanInfo#Install4JBeanInfo(String, String, String, boolean, boolean, Integer, Class, Class)
 */
public interface CustomizerCallback {
    /**
     * Called by the install4j GUI when the user moves to another bean or to a different configuration step.
     * This is useful if your customizer does not save user input directly to the bean.
     */
    void stopEditing();

    /**
     * Called by the install4j GUI after the customizer is initialized and sets the parent window.
     * This is useful if you need a parent window for your own dialogs.
     * @param window the parent window
     */
    void setParentWindow(Window window);

    /**
     * Called by the install4j GUI when the user exports a project report.
     * Your customizer can contribute to the project report with this method.
     * @return the project report elements contributed by this customizer
     */
    ProjectReportProperty[] getProjectReportProperties();
}
