package com.install4j.api.beaninfo;

import com.install4j.api.actions.Action;
import com.install4j.api.beans.ActionList;

import java.util.List;

/**
 * Interface for the {@link ActionBeanInfo#ATTRIBUTE_ACTION_LIST_INITIALIZER} value of a bean descriptor.
 * With an action list initializer, you can modify actions after they are instantiated in an action list.
 * <p>This is useful if you have default property values that should be different if the action is
 * instantiated in an action list. This initializer is run after the {@link BeanInitializer}.
 */
public interface ActionListInitializer {
    /**
     * Called after the unconfigured action is instantiated the first time at design-time.
     * For existing action instances that are loaded from a project, this method is not called
     * after instantiation.
     * @param action the action that should be initialized
     * @param actionKeys the action keys configured for the {@link ActionList} property by calling
     *                   {@link ActionListPropertyDescriptor#setActionKeys(String[])}
     */
    void initializeAction(Action action, List<String> actionKeys);
}
