package com.install4j.api.beaninfo;

import com.install4j.runtime.installer.InstallerConstants;

/**
 * Enumeration class for all possible elevation strategies for actions.
 * @see ActionBeanInfo#setDefaultActionElevationType(ActionElevationType)
 */
public enum ActionElevationType {

    /**
     * The action elevation type will be inherited from the parent element, such as
     * the action or screen group, the screen or the installer application itself.
     */
    INHERIT(InstallerConstants.ACTION_ELEVATION_TYPE_INHERIT),

    /**
     * The action will not be elevated, it will run in-process as the original user.
     */
    NONE(InstallerConstants.ACTION_ELEVATION_TYPE_NONE),

    /**
     * If elevated privileges are available, the action will be run in the elevated helper process.
     */
    ELEVATE(InstallerConstants.ACTION_ELEVATION_TYPE_ELEVATE);

    private final int id;

    ActionElevationType(int id) {
        this.id = id;
    }

    /**
     * Convert to an int value.
     * @return the int value
     */
    public int getId() {
        return id;
    }
}
