package com.install4j.api.actions;

import com.install4j.api.beans.AbstractBean;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;

/**
 * Abstract base class for actions that can be used for installation or uninstallation.
 * The {@code rollback} method does nothing by default. Override it in your action to perform an actual rollback.
 *
 * @author ej-technologies GmbH
 */
public abstract class AbstractInstallOrUninstallAction extends AbstractBean implements InstallAction, UninstallAction {

    @Override
    public void rollback(InstallerContext context) {
    }

    @Override
    public void init(Context context) {
    }

    @Override
    public boolean isRollbackSupported() {
        return true;
    }
}
