/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;

public class CachedVector<E>
extends Vector<E> {
    private static final long serialVersionUID = -4994486169224407197L;
    private Map<Object, IntegerWrapper> _indexCache;
    private boolean _lazyCaching = false;

    public CachedVector() {
    }

    public CachedVector(Collection<? extends E> collection) {
        super(collection);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedVector(int n2) {
        super(n2);
    }

    @Override
    public int indexOf(Object object) {
        this.initializeCache();
        IntegerWrapper integerWrapper = this._indexCache.get(object);
        if (integerWrapper != null) {
            return integerWrapper.integer;
        }
        if (this.isLazyCaching()) {
            int n2 = super.indexOf(object);
            if (n2 == -1) {
                this.uncacheIt(object);
            } else {
                this.cacheIt(object, n2);
            }
            return n2;
        }
        return -1;
    }

    protected synchronized void adjustCache(int n2, int n3) {
        if (this._indexCache != null) {
            if (this.size() - n2 <= this.size() >> 2) {
                Collection<IntegerWrapper> collection = this._indexCache.values();
                for (IntegerWrapper integerWrapper : collection) {
                    if (integerWrapper.integer < n2) continue;
                    integerWrapper.integer += n3;
                }
            } else {
                this.uncacheAll();
                if (!this.isLazyCaching()) {
                    this.cacheAll();
                }
            }
        }
    }

    protected Map<Object, IntegerWrapper> createCache() {
        return new IdentityHashMap<Object, IntegerWrapper>();
    }

    public synchronized void cacheIt(Object object, int n2) {
        if (this._indexCache != null && (this._indexCache.get(object) == null || n2 < this._indexCache.get((Object)object).integer)) {
            this._indexCache.put(object, new IntegerWrapper(n2));
        }
    }

    public synchronized void uncacheIt(Object object) {
        if (this._indexCache != null) {
            this._indexCache.remove(object);
        }
    }

    @Override
    public synchronized boolean add(E e2) {
        boolean bl2 = super.add(e2);
        if (!this.isLazyCaching() && bl2) {
            this.initializeCache();
            this.cacheIt(e2, this.size() - 1);
        }
        return bl2;
    }

    @Override
    public synchronized void add(int n2, E e2) {
        super.add(n2, e2);
        if (!this.isLazyCaching()) {
            this.initializeCache();
            this.adjustCache(n2, 1);
            this.cacheIt(e2, n2);
        } else if (this._indexCache != null) {
            this.adjustCache(n2, 1);
            this.cacheIt(e2, n2);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    @Override
    public synchronized E remove(int n2) {
        Object e2 = super.remove(n2);
        if (e2 != null) {
            this.uncacheIt(e2);
            this.adjustCache(n2, -1);
        }
        return e2;
    }

    @Override
    public synchronized boolean remove(Object object) {
        int n2 = this.indexOf(object);
        boolean bl2 = super.remove(object);
        if (bl2) {
            this.uncacheIt(object);
            this.adjustCache(n2, -1);
        }
        return bl2;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        this.uncacheAll();
        return super.removeAll(collection);
    }

    @Override
    public synchronized void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        boolean bl2 = super.addAll(collection);
        if (bl2) {
            this.cacheAll();
        }
        return bl2;
    }

    @Override
    public synchronized boolean addAll(int n2, Collection<? extends E> collection) {
        boolean bl2 = super.addAll(n2, collection);
        this.initializeCache();
        this.adjustCache(n2, collection.size());
        for (E e2 : collection) {
            this.cacheIt(e2, n2++);
        }
        return bl2;
    }

    @Override
    public synchronized E set(int n2, E e2) {
        if (!this.isLazyCaching()) {
            this.initializeCache();
            E e3 = super.set(n2, e2);
            this.uncacheIt(e3);
            this.cacheIt(e2, n2);
            return e3;
        }
        return super.set(n2, e2);
    }

    public synchronized void invalidateCache() {
        this.uncacheAll();
    }

    public synchronized void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public synchronized void cacheAll() {
        this._indexCache = this.createCache();
        Integer n2 = 0;
        for (Object e2 : this) {
            if (this._indexCache.get(e2) == null) {
                this._indexCache.put(e2, new IntegerWrapper(n2));
            }
            Integer n3 = n2;
            n2 = n2 + 1;
        }
    }

    public boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public void setLazyCaching(boolean bl2) {
        this._lazyCaching = bl2;
    }

    @Override
    protected synchronized void removeRange(int n2, int n3) {
        if (n2 == n3) {
            this.remove(n2);
        } else {
            super.removeRange(n2, n3);
            this.uncacheAll();
            if (!this.isLazyCaching()) {
                this.cacheAll();
            }
        }
    }

    public static class IntegerWrapper {
        int integer;

        private IntegerWrapper(int n2) {
            this.integer = n2;
        }
    }
}

