/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Range;

public class StringRange
extends AbstractRange<String> {
    private String _lower;
    private String _upper;

    public StringRange(String string, String string2) {
        this.adjust(string, string2);
    }

    @Override
    public Range<String> createIntermediate(Range<String> range, double d2) {
        return null;
    }

    @Override
    public String lower() {
        return this._lower;
    }

    @Override
    public String upper() {
        return this._lower;
    }

    @Override
    public void adjust(String string, String string2) {
        this.setMin(string);
        this.setMax(string2);
    }

    protected void setMin(String string) {
        String string2 = this._lower;
        this._lower = string;
        this.firePropertyChange("min", string2, this._lower);
    }

    protected void setMax(String string) {
        String string2 = this._upper;
        this._upper = string;
        this.firePropertyChange("max", string2, this._upper);
    }

    @Override
    public double minimum() {
        throw new UnsupportedOperationException("minimum() is not implemented in StringRange");
    }

    @Override
    public double maximum() {
        throw new UnsupportedOperationException("maximum() is not implemented in StringRange");
    }

    @Override
    public double size() {
        return Math.abs(this._lower.compareTo(this._upper));
    }

    @Override
    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        return string.compareTo(this.lower()) >= 0 && string.compareTo(this.upper()) <= 0;
    }

    public String toString() {
        return "StringRange{lower='" + this._lower + "', upper='" + this._upper + "'}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StringRange)) {
            return false;
        }
        StringRange stringRange = (StringRange)object;
        if (this._lower != null ? !this._lower.equals(stringRange._lower) : stringRange._lower != null) {
            return false;
        }
        return !(this._upper != null ? !this._upper.equals(stringRange._upper) : stringRange._upper != null);
    }

    public int hashCode() {
        int n2 = this._lower != null ? this._lower.hashCode() : 0;
        n2 = 31 * n2 + (this._upper != null ? this._upper.hashCode() : 0);
        return n2;
    }

    @Override
    public int compareTo(Range range) {
        if (range instanceof StringRange) {
            int n2 = this._lower.compareTo(((StringRange)range)._lower);
            if (this.size() == 0.0 && range.size() == 0.0) {
                return n2;
            }
            if (this.size() == 0.0 && this.size() < range.size()) {
                return -1;
            }
            if (range.size() == 0.0 && this.size() > range.size()) {
                return 1;
            }
            return n2 == 0 ? this._upper.compareTo(((StringRange)range)._upper) : n2;
        }
        return 0;
    }
}

