/*
 * Decompiled with CFR 0.152.
 */
package org.pkcs11.jacknji11.jna;

import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import org.pkcs11.jacknji11.CK_TOKEN_INFO;
import org.pkcs11.jacknji11.jna.JNA_CK_VERSION;

public class JNA_CK_TOKEN_INFO
extends Structure {
    public byte[] label;
    public byte[] manufacturerID;
    public byte[] model;
    public byte[] serialNumber;
    public NativeLong flags;
    public NativeLong ulMaxSessionCount;
    public NativeLong ulSessionCount;
    public NativeLong ulMaxRwSessionCount;
    public NativeLong ulRwSessionCount;
    public NativeLong ulMaxPinLen;
    public NativeLong ulMinPinLen;
    public NativeLong ulTotalPublicMemory;
    public NativeLong ulFreePublicMemory;
    public NativeLong ulTotalPrivateMemory;
    public NativeLong ulFreePrivateMemory;
    public JNA_CK_VERSION hardwareVersion;
    public JNA_CK_VERSION firmwareVersion;
    public byte[] utcTime;

    protected List<String> getFieldOrder() {
        return Arrays.asList("label", "manufacturerID", "model", "serialNumber", "flags", "ulMaxSessionCount", "ulSessionCount", "ulMaxRwSessionCount", "ulRwSessionCount", "ulMaxPinLen", "ulMinPinLen", "ulTotalPublicMemory", "ulFreePublicMemory", "ulTotalPrivateMemory", "ulFreePrivateMemory", "hardwareVersion", "firmwareVersion", "utcTime");
    }

    public JNA_CK_TOKEN_INFO readFrom(CK_TOKEN_INFO info) {
        this.label = info.label;
        this.manufacturerID = info.manufacturerID;
        this.model = info.model;
        this.serialNumber = info.serialNumber;
        this.flags = new NativeLong(info.flags);
        this.ulMaxSessionCount = new NativeLong(info.ulMaxSessionCount);
        this.ulSessionCount = new NativeLong(info.ulSessionCount);
        this.ulMaxRwSessionCount = new NativeLong(info.ulMaxRwSessionCount);
        this.ulRwSessionCount = new NativeLong(info.ulRwSessionCount);
        this.ulMaxPinLen = new NativeLong(info.ulMaxPinLen);
        this.ulMinPinLen = new NativeLong(info.ulMinPinLen);
        this.ulTotalPublicMemory = new NativeLong(info.ulTotalPublicMemory);
        this.ulFreePublicMemory = new NativeLong(info.ulFreePublicMemory);
        this.ulTotalPrivateMemory = new NativeLong(info.ulTotalPrivateMemory);
        this.ulFreePrivateMemory = new NativeLong(info.ulFreePrivateMemory);
        this.hardwareVersion = new JNA_CK_VERSION().readFrom(info.hardwareVersion);
        this.firmwareVersion = new JNA_CK_VERSION().readFrom(info.firmwareVersion);
        this.utcTime = info.utcTime;
        return this;
    }

    public CK_TOKEN_INFO writeTo(CK_TOKEN_INFO info) {
        info.label = this.label;
        info.manufacturerID = this.manufacturerID;
        info.model = this.model;
        info.serialNumber = this.serialNumber;
        info.flags = this.flags.intValue();
        info.ulMaxSessionCount = this.ulMaxSessionCount.intValue();
        info.ulSessionCount = this.ulSessionCount.intValue();
        info.ulMaxRwSessionCount = this.ulMaxRwSessionCount.intValue();
        info.ulRwSessionCount = this.ulRwSessionCount.intValue();
        info.ulMaxPinLen = this.ulMaxPinLen.intValue();
        info.ulMinPinLen = this.ulMinPinLen.intValue();
        info.ulTotalPublicMemory = this.ulTotalPublicMemory.intValue();
        info.ulFreePublicMemory = this.ulFreePublicMemory.intValue();
        info.ulTotalPrivateMemory = this.ulTotalPrivateMemory.intValue();
        info.ulFreePrivateMemory = this.ulFreePrivateMemory.intValue();
        this.hardwareVersion.writeTo(info.hardwareVersion);
        this.firmwareVersion.writeTo(info.firmwareVersion);
        info.utcTime = this.utcTime;
        return info;
    }
}

