/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.io;

import java.io.EOFException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.Buffer;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import org.gjt.jclasslib.io.CountingSinkDataOutput;
import org.gjt.jclasslib.io.CountingSourceDataInput;
import org.gjt.jclasslib.io.SinkDataOutput;
import org.gjt.jclasslib.io.SourceDataInput;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.Package;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u000b\u001a\u00020\n*\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0001\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\bH\u0002\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"readFromPath", "Lorg/gjt/jclasslib/structures/ClassFile;", "path", "Lkotlinx/io/files/Path;", "suppressEOF", "", "readFromSource", "source", "Lkotlinx/io/RawSource;", "writeToPath", "", "writeToSink", "sink", "Lkotlinx/io/RawSink;", "writeToByteArray", "", "createDataInput", "Lorg/gjt/jclasslib/io/SourceDataInput;", "createDataOutput", "Lorg/gjt/jclasslib/io/SinkDataOutput;", "data"})
public final class ClassFileIOKt {
    @NotNull
    public static final ClassFile readFromPath(@NotNull Path path, boolean suppressEOF) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return ClassFileIOKt.readFromSource(FileSystemJvmKt.SystemFileSystem.source(path), suppressEOF);
    }

    public static /* synthetic */ ClassFile readFromPath$default(Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ClassFileIOKt.readFromPath(path, bl);
    }

    @NotNull
    public static final ClassFile readFromSource(@NotNull RawSource source, boolean suppressEOF) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ClassFile classFile = new ClassFile();
        SourceDataInput input = ClassFileIOKt.createDataInput(source);
        if (suppressEOF) {
            try {
                classFile.read(input);
            }
            catch (EOFException e) {
                if (Package.isDebug()) {
                    Package.debug("A suppressed end-of-file occurred while reading the class file: " + e.getMessage(), input);
                }
            }
        } else {
            classFile.read(input);
        }
        return classFile;
    }

    public static /* synthetic */ ClassFile readFromSource$default(RawSource rawSource, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ClassFileIOKt.readFromSource(rawSource, bl);
    }

    public static final void writeToPath(@NotNull ClassFile $this$writeToPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$writeToPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ClassFileIOKt.writeToSink($this$writeToPath, FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)path, (boolean)false, (int)2, null));
    }

    public static final void writeToSink(@NotNull ClassFile $this$writeToSink, @NotNull RawSink sink) {
        SinkDataOutput sinkDataOutput;
        Intrinsics.checkNotNullParameter((Object)$this$writeToSink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        SinkDataOutput it = sinkDataOutput = ClassFileIOKt.createDataOutput(sink);
        boolean bl = false;
        $this$writeToSink.write(it);
        it.flush();
    }

    @NotNull
    public static final byte[] writeToByteArray(@NotNull ClassFile $this$writeToByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$writeToByteArray, (String)"<this>");
        Buffer it = new Buffer();
        boolean bl = false;
        ClassFileIOKt.writeToSink($this$writeToByteArray, (RawSink)it);
        return SourcesKt.readByteArray((Source)((Source)it));
    }

    private static final SourceDataInput createDataInput(RawSource $this$createDataInput) {
        Source source = CoreKt.buffered((RawSource)$this$createDataInput);
        return Package.isDebug() ? (SourceDataInput)new CountingSourceDataInput(source) : new SourceDataInput(source);
    }

    private static final SinkDataOutput createDataOutput(RawSink $this$createDataOutput) {
        Sink sink = CoreKt.buffered((RawSink)$this$createDataOutput);
        return Package.isDebug() ? (SinkDataOutput)new CountingSinkDataOutput(sink) : new SinkDataOutput(sink);
    }
}

