/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.registry;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.registry.NoRegistry;
import com.install4j.runtime.installer.helper.registry.PreferencesRegistry;
import com.install4j.runtime.installer.helper.registry.RegistryInterface;
import com.install4j.runtime.installer.helper.registry.Win32Registry;
import com.install4j.runtime.util.Base64;
import com.install4j.runtime.util.UserDirs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class InstallRegistry {
    private static final String REGVAL_PREFIX_INST_DIR = "instdir";
    public static final String REGVAL_PREFIX_ALL_INST_DIR = "allinstdirs";
    private static final String REGVAL_PREFIX_SINGLE_BUNDLE_NAME = "singleBundleName";
    private static final String DELIMITER = ";";
    public static final String APPS_DIR = "install4j/apps";
    private static RegistryInterface registry;

    public static String getFileEncodedApplicationId(String applicationId) {
        if (applicationId == null || applicationId.isEmpty()) {
            applicationId = "unknown";
        }
        return Base64.encodeForFiles(applicationId).replace('=', '_');
    }

    public static boolean isNoPreferences() {
        return Boolean.getBoolean("noPreferences") || ContextImpl.getSingleContextInt() != null && ContextImpl.getSingleContextInt().getBooleanVariable("sys.noPreferences");
    }

    public static void registerApplication(String applicationId, File installationDir) {
        HelperCommunication.getInstance().runAction(ExecutionContext.MAXIMUM, context -> InstallRegistry.registerApplicationInt(applicationId, installationDir));
        InstallRegistry.handleForScript(applicationId, installationDir, true);
    }

    private static void handleForScript(String applicationId, File installationDir, boolean add) {
        if (!Util.isWindowsInstaller() && !Util.isMacosInstaller()) {
            HelperCommunication.getInstance().runAction(ExecutionContext.UNELEVATED, context -> InstallRegistry.handleForScriptUnelevated(applicationId, installationDir, add));
        }
    }

    private static void handleForScriptUnelevated(String applicationId, File installationDir, boolean add) {
        File appsDir = new File(UserDirs.getDataDir(), APPS_DIR);
        appsDir.mkdirs();
        File file = new File(appsDir, InstallRegistry.getFileEncodedApplicationId(applicationId));
        String canonicalInstallationDir = FileUtil.getCanonicalPath(installationDir);
        try {
            ArrayList<String> allInstallations = new ArrayList<String>();
            if (add) {
                allInstallations.add(canonicalInstallationDir);
            }
            if (file.isFile()) {
                allInstallations.addAll(Files.readAllLines(file.toPath()).stream().filter(line -> !line.equals(canonicalInstallationDir)).collect(Collectors.toList()));
            }
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                for (String installation : allInstallations) {
                    pw.println(installation);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void registerApplicationInt(String applicationId, File installationDir) {
        InstallRegistry.init();
        try {
            installationDir = installationDir.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String singleInstDir = registry.getValue(REGVAL_PREFIX_INST_DIR + applicationId, false);
        InstallRegistry.unregisterApplicationInt(applicationId, installationDir);
        String allKeyName = REGVAL_PREFIX_ALL_INST_DIR + applicationId;
        String instDirValue = registry.getValue(allKeyName, false);
        if (instDirValue == null) {
            if (singleInstDir != null && !singleInstDir.trim().isEmpty()) {
                try {
                    File singleFile = new File(singleInstDir).getCanonicalFile();
                    if (!Objects.equals(singleFile, installationDir)) {
                        instDirValue = installationDir.getAbsolutePath() + DELIMITER + singleFile.getAbsolutePath();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (instDirValue == null) {
                instDirValue = installationDir.getAbsolutePath();
            }
        } else {
            instDirValue = installationDir.getAbsolutePath() + DELIMITER + instDirValue;
        }
        registry.setValue(allKeyName, instDirValue);
        registry.setValue(REGVAL_PREFIX_INST_DIR + applicationId, installationDir.getAbsolutePath());
    }

    public static void unregisterApplication(String applicationId, File installationDir) {
        HelperCommunication.getInstance().runAction(ExecutionContext.MAXIMUM, context -> InstallRegistry.unregisterApplicationInt(applicationId, installationDir));
        InstallRegistry.handleForScript(applicationId, installationDir, false);
    }

    private static void unregisterApplicationInt(String applicationId, File installationDir) {
        String newInstDirValue;
        InstallRegistry.init();
        try {
            installationDir = installationDir.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        registry.deleteValue(REGVAL_PREFIX_INST_DIR + applicationId);
        String allKeyName = REGVAL_PREFIX_ALL_INST_DIR + applicationId;
        String instDirValue = registry.getValue(allKeyName, false);
        StringBuilder buffer = new StringBuilder();
        if (instDirValue != null) {
            StringTokenizer tokenizer = new StringTokenizer(instDirValue, DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                String value = tokenizer.nextToken();
                try {
                    if (Objects.equals(new File(value).getCanonicalFile(), installationDir)) continue;
                    buffer.append(value).append(DELIMITER);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (Objects.equals(newInstDirValue = buffer.toString(), "")) {
            registry.deleteValue(allKeyName);
        } else {
            registry.setValue(allKeyName, newInstDirValue);
        }
        registry.deleteValue(REGVAL_PREFIX_SINGLE_BUNDLE_NAME + applicationId + "_" + installationDir.getAbsolutePath());
    }

    public static String getInstallationDir(String applicationId, boolean allUsers) {
        String[] allDirs;
        for (String dir : allDirs = InstallRegistry.getAllInstallationDirs(applicationId, allUsers, false)) {
            boolean isAllUsers;
            boolean bl = isAllUsers = !InstallerUtil.isUserInstallation(new File(dir));
            if (isAllUsers != allUsers) continue;
            return dir;
        }
        return null;
    }

    public static String[] getAllInstallationDirs(String applicationId, boolean preferAllUsers, boolean checkOtherBitness) {
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<String> addedDirs = new HashSet<String>();
        InstallRegistry.addAllInstallationDirs(applicationId, ret, addedDirs, preferAllUsers, false);
        if (checkOtherBitness) {
            InstallRegistry.addAllInstallationDirs(applicationId, ret, addedDirs, preferAllUsers, true);
        }
        return ret.toArray(new String[0]);
    }

    private static void addAllInstallationDirs(String applicationId, List<String> ret, Set<String> addedDirs, boolean preferAllUsers, boolean otherBitness) {
        String instDirs = InstallRegistry.getValue(REGVAL_PREFIX_ALL_INST_DIR + applicationId, preferAllUsers, otherBitness);
        if (instDirs != null) {
            StringTokenizer tokenizer = new StringTokenizer(instDirs, DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                String value = tokenizer.nextToken();
                if (value == null || value.trim().isEmpty() || !addedDirs.add(value) || InstallRegistry.getSingleBundleName(applicationId, value, preferAllUsers) != null) continue;
                ret.add(value);
            }
        } else {
            String value = InstallRegistry.getValue(REGVAL_PREFIX_INST_DIR + applicationId, preferAllUsers, otherBitness);
            if (value != null && !value.trim().isEmpty() && addedDirs.add(value) && InstallRegistry.getSingleBundleName(applicationId, value, preferAllUsers) == null) {
                ret.add(value);
            }
        }
    }

    private static String getSingleBundleName(String applicationId, String installationDir, boolean preferAllUsers) {
        try {
            return InstallRegistry.getValue(REGVAL_PREFIX_SINGLE_BUNDLE_NAME + applicationId + "_" + new File(installationDir).getCanonicalFile(), preferAllUsers);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getValue(String valueName) {
        return InstallRegistry.getValue(valueName, false);
    }

    private static String getValue(String valueName, boolean preferAllUsers) {
        InstallRegistry.init();
        return registry.getValue(valueName, preferAllUsers);
    }

    private static String getValue(String valueName, boolean preferAllUsers, boolean otherBitness) {
        InstallRegistry.init();
        if (otherBitness) {
            return registry.getOtherBitnessValue(valueName);
        }
        return registry.getValue(valueName, preferAllUsers);
    }

    public static void setValue(String valueName, String value) {
        HelperCommunication.getInstance().runAction(ExecutionContext.MAXIMUM, context -> {
            InstallRegistry.init();
            registry.deleteValue(valueName);
            registry.setValue(valueName, value);
        });
    }

    private static void init() {
        if (registry == null) {
            registry = InstallerUtil.isWindows() ? new Win32Registry() : (InstallRegistry.isNoPreferences() ? new NoRegistry() : new PreferencesRegistry());
        }
    }
}

