/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.buildtools;

import com.install4j.buildtools.BaseProjectTaskConfig;
import com.install4j.buildtools.InvalidConfigException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Install4jTaskConfig
extends BaseProjectTaskConfig {
    public static final String COMPILER_EXECUTABLE_NAME = "install4jc";
    private final boolean faster;
    private final boolean disableSigning;
    private final boolean disableBundling;
    private final boolean buildSelected;
    @Nullable
    private final List<String> buildIds;
    @Nullable
    private final List<String> mediaTypes;
    private final boolean incremental;
    private final boolean debug;
    private final boolean preserve;
    @Nullable
    private final String winKeystorePassword;
    @Nullable
    private final String macKeystorePassword;
    private final boolean disableNotarization;
    @NotNull
    private final Map<String, String> variables;
    @NotNull
    private final List<File> variableFiles;
    private File variablesTempFile;

    public Install4jTaskConfig(@Nullable File installDir, @Nullable File autoProvisioningCacheDir, @NotNull List<String> vmParameters, File projectFile, boolean verbose, boolean quiet, boolean test, boolean failOnWarning, String release, File destination, String license, boolean faster, boolean disableSigning, boolean disableBundling, boolean buildSelected, @Nullable List<String> buildIds, @Nullable List<String> mediaTypes, boolean incremental, boolean debug, boolean preserve, @Nullable String winKeystorePassword, @Nullable String macKeystorePassword, boolean disableNotarization, @NotNull Map<String, String> variables, @NotNull List<File> variableFiles) {
        super(installDir, autoProvisioningCacheDir, vmParameters, projectFile, verbose, quiet, test, failOnWarning, release, destination, license);
        this.faster = faster;
        this.disableSigning = disableSigning;
        this.disableBundling = disableBundling;
        this.buildSelected = buildSelected;
        this.buildIds = buildIds;
        this.mediaTypes = mediaTypes;
        this.incremental = incremental;
        this.debug = debug;
        this.preserve = preserve;
        this.winKeystorePassword = winKeystorePassword;
        this.macKeystorePassword = macKeystorePassword;
        this.disableNotarization = disableNotarization;
        this.variables = variables;
        this.variableFiles = variableFiles;
    }

    @Override
    @NotNull
    protected String getExecutableName() {
        return COMPILER_EXECUTABLE_NAME;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.variablesTempFile != null) {
            this.variablesTempFile.delete();
        }
    }

    @Override
    protected void addVmParameters(List<String> commandLine2) {
        this.addVmParameter("-Dinstall4j.mergeStderr=true", commandLine2);
        super.addVmParameters(commandLine2);
    }

    @Override
    @Nullable
    public String getExtraLoggingOutput() {
        File usedExecutableFile = this.getUsedExecutableFile();
        return "Variables file: " + this.variablesTempFile + "\nExecutable: " + usedExecutableFile;
    }

    @Override
    protected void addAdditionalOptions(List<String> commandLine2) throws InvalidConfigException {
        super.addAdditionalOptions(commandLine2);
        if (this.winKeystorePassword != null) {
            commandLine2.add("--win-keystore-password=" + this.winKeystorePassword);
        }
        if (this.macKeystorePassword != null) {
            commandLine2.add("--mac-keystore-password=" + this.macKeystorePassword);
        }
        if (this.disableNotarization) {
            commandLine2.add("--disable-notarization");
        }
        if (this.preserve) {
            commandLine2.add("-p");
        }
        if (this.faster) {
            commandLine2.add("-n");
        }
        if (this.disableSigning) {
            commandLine2.add("-u");
        }
        if (this.disableBundling) {
            commandLine2.add("-j");
        }
        if (this.debug && !this.incremental) {
            commandLine2.add("-g");
        }
        if (this.incremental) {
            if (this.isTest()) {
                throw new InvalidConfigException("Cannot set both test and incremental");
            }
            commandLine2.add("-i");
        }
        if (this.buildSelected) {
            commandLine2.add("-s");
        }
        if (this.buildIds != null && !this.buildIds.isEmpty()) {
            commandLine2.add("-b");
            commandLine2.add(this.join(this.buildIds, ","));
        }
        if (this.mediaTypes != null && !this.mediaTypes.isEmpty()) {
            commandLine2.add("-m");
            commandLine2.add(this.join(this.mediaTypes, ","));
        }
        if (!this.variableFiles.isEmpty() || !this.variables.isEmpty()) {
            commandLine2.add("-f");
            StringBuilder buffer = new StringBuilder();
            for (File variableFile : this.variableFiles) {
                if (buffer.length() > 0) {
                    buffer.append(";");
                }
                buffer.append(variableFile.getPath());
            }
            if (!this.variables.isEmpty()) {
                if (buffer.length() > 0) {
                    buffer.append(";");
                }
                buffer.append(this.createVariablesTempFile().getPath());
            }
            commandLine2.add(buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createVariablesTempFile() throws InvalidConfigException {
        try {
            File file = File.createTempFile("install4jVariables", ".txt");
            file.deleteOnExit();
            FileOutputStream out = new FileOutputStream(file);
            out.write(BOM);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            try {
                for (Map.Entry<String, String> entry : this.variables.entrySet()) {
                    pw.print(entry.getKey());
                    pw.print('=');
                    pw.println(entry.getValue());
                }
            }
            finally {
                pw.flush();
                pw.close();
            }
            this.variablesTempFile = file;
            return file;
        }
        catch (IOException e) {
            throw new InvalidConfigException("Cannot create temporary file for variable definitions");
        }
    }

    public static interface Provider {
        public Install4jTaskConfig createTaskConfig();
    }
}

