/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.buildtools;

import com.install4j.buildtools.shadowed.ejt.util.CommonPlatformUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class BuildToolHelper {
    private static final int FAT_MAGIC = -889275714;
    private static final int FAT_CIGAM = -1095041334;
    private static int MH_MAGIC = -17958194;
    private static int MH_CIGAM = -822415874;
    private static int MH_MAGIC_64 = -17958193;
    private static int MH_CIGAM_64 = -805638658;

    public static boolean isMacosScript(File executableFile) {
        try {
            return executableFile.isFile() && !BuildToolHelper.isAnyMacho(executableFile.toPath());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAnyMacho(Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0]) && Files.size(path) > 4L) {
            try (DataInputStream in = new DataInputStream(Files.newInputStream(path, StandardOpenOption.READ));){
                int magic = in.readInt();
                boolean bl = BuildToolHelper.isFatMagic(magic) || BuildToolHelper.isThinMagic(magic);
                return bl;
            }
        }
        return false;
    }

    private static boolean isThinMagic(int magic) {
        return magic == MH_MAGIC || magic == MH_CIGAM || magic == MH_MAGIC_64 || magic == MH_CIGAM_64;
    }

    private static boolean isFatMagic(int magic) {
        return magic == -889275714 || magic == -1095041334;
    }

    public static File getInstall4jExecutableFile(File installDir, String executableName) {
        File binDir = new File(installDir, "bin");
        File file = new File(binDir, executableName + (CommonPlatformUtil.isWindows() ? ".exe" : ""));
        if (!file.exists() && CommonPlatformUtil.isMacOS()) {
            return new File(installDir, "Contents/Resources/app/bin/" + executableName);
        }
        return file;
    }

    public static File getDefaultAutoProvisioningCacheDir() {
        return new File(BuildToolHelper.getCachesDir(), "install4jDist");
    }

    public static File getCachesDir() {
        if (CommonPlatformUtil.isWindows()) {
            String localAppDataDir = System.getenv("LOCALAPPDATA");
            if (localAppDataDir != null) {
                return new File(localAppDataDir);
            }
            return new File(System.getProperty("user.home"), "AppData\\Local");
        }
        if (CommonPlatformUtil.isMacOS()) {
            return new File(System.getProperty("user.home"), "Library/Caches");
        }
        String configDir = System.getenv("XDG_CACHE_HOME");
        if (configDir != null && !configDir.isEmpty()) {
            return new File(configDir);
        }
        return new File(System.getProperty("user.home"), ".cache");
    }
}

