/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.styles;

import com.install4j.api.beaninfo.BeanInitializer;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.Install4JBeanInfo;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.api.context.ControlButtonType;
import com.install4j.b;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.common.BeanIconHolder;
import com.install4j.runtime.beans.common.CategoryUtil;
import com.install4j.runtime.beans.formcomponents.FormComponentUtil;
import com.install4j.runtime.beans.formcomponents.SystemFormComponentBeanInfo;
import com.install4j.runtime.beans.styles.StandardControlButtonComponent;

@BeanInfo
public class StandardControlButtonComponentBeanInfo
extends SystemFormComponentBeanInfo
implements BeanInitializer,
BeanValidator {
    private static final BeanIconHolder ICON = b.f("control_component.svg");
    private static final String PROPERTY_CONTROL_BUTTON_TYPE = "controlButtonType";

    public StandardControlButtonComponentBeanInfo() {
        super("Control button", "A control button that handles the user actions with respect to the screen flow. This includes activating the next screen, activating the previous screen and cancelling the wizard.<p>The keyboard shortcuts for control buttons are</p><ul><li>Previous: <tt>Alt + Left Arrow</tt> / <tt>\u2303\u2325\u2190</tt> on macOS</li><li>Next: <tt>Alt + Right Arrow</tt> / <tt>\u2303\u2325\u2192</tt> on macOS</li><li>Cancel: Escape</li></ul>", null, null, StandardControlButtonComponent.class);
        this.addPropertyDescriptor(CategoryUtil.categoryButton(Install4JPropertyDescriptor.create((String)PROPERTY_CONTROL_BUTTON_TYPE, (Class)this.getBeanClass(), (String)"Control button type", (String)"Depending on the selected control button type, the appropriate action will be performed when the user activates the button.")));
        FormComponentUtil.addCommonButtonProperties((Install4JBeanInfo)this);
        this.setIcons(ICON);
    }

    public void validateBean(Bean bean) throws BeanValidationException {
        FormComponentUtil.validateCommonButtonProperties(bean, (Install4JBeanInfo)this);
    }

    public void initializeBean(Bean bean) {
        StandardControlButtonComponent standardControlButtonComponent = (StandardControlButtonComponent)bean;
        standardControlButtonComponent.setControlButtonType(ControlButtonType.NEXT);
        standardControlButtonComponent.setButtonText("${i18n:ButtonNext}");
    }
}

