/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.FilePropertyDescriptor;
import com.install4j.api.beaninfo.FileSelectionMode;
import com.install4j.api.beaninfo.Install4JBeanInfo;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import com.install4j.runtime.beans.formcomponents.FormComponentUtil;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponentBeanInfo;
import com.install4j.runtime.beans.formcomponents.LogFileViewerComponent;

@BeanInfo
public class LogFileViewerComponentBeanInfo
extends LeadingLabelComponentBeanInfo
implements BeanValidator {
    private static final String CATEGORY_LOG_FILE = "Log file viewer";
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_ENCODING = "encoding";
    public static final String PROPERTY_MAX_LINES = "maxLines";

    public LogFileViewerComponentBeanInfo() {
        super(CATEGORY_LOG_FILE, "A text area that shows the contents of a text file. The viewer follows additions to the file like the UNIX command <tt>tail -f</tt>, with a configurable maximum number of displayed lines.<p>The log file does not have to exist when the form is shown, it can be created later on. Also, the file can be deleted and re-created. Modifications before the previously observed end of the file will not be picked up by the viewer unless the length of the file decreases.</p>", "Special selectors and displays", (Integer)null, (Class<? extends LeadingLabelComponent>)LogFileViewerComponent.class);
        this.addPropertyDescriptor(this.categoryLogFile((Install4JPropertyDescriptor)FilePropertyDescriptor.create((String)PROPERTY_FILE, (Class)this.getBeanClass(), (String)"Log file", (String)"The text file that should be displayed. It does not have to exist when the form is shown.", (FileSelectionMode)FileSelectionMode.FILES_ONLY, (String[])new String[]{"log", "txt"}, (String)"Text files")));
        BeanInfoUtil.addEncodingProperty((Install4JBeanInfo)this, PROPERTY_ENCODING, CATEGORY_LOG_FILE, "Log file encoding");
        this.addPropertyDescriptor(this.categoryLogFile(Install4JPropertyDescriptor.create((String)PROPERTY_MAX_LINES, (Class)this.getBeanClass(), (String)"Maximum number of displayed lines", (String)"The maximum number of lines that should be kept in the text display. Excess lines are removed from the beginning.")));
        FormComponentUtil.addRowsProperty((Install4JBeanInfo)this, CATEGORY_LOG_FILE);
        FormComponentUtil.addFillVerticalDescriptor(this, CATEGORY_LOG_FILE);
        BeanInfoUtil.addWidgetStyleProperties((Install4JBeanInfo)this, "Text component style", CATEGORY_LOG_FILE);
    }

    private Install4JPropertyDescriptor categoryLogFile(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory(CATEGORY_LOG_FILE);
        return install4JPropertyDescriptor;
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        this.checkNotEmpty(PROPERTY_FILE, bean);
        FormComponentUtil.validateRows(bean, (Install4JBeanInfo)this);
    }
}

