<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- install4j 11.0 -->
<xsl:transform version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns=""
               xmlns:math="http://exslt.org/math"
               xmlns:ext="com.install4j.config.XsltExtensions"
               extension-element-prefixes="ext math">

  <xsl:include href="common.xsl"/>

  <xsl:template match="/install4j/application/searchSequence/registry">
    <installations/>
    <registry/>
  </xsl:template>

  <xsl:template match="/install4j/mediaSets/macos"/>
  <xsl:template match="/install4j/mediaSets/macosFolder | /install4j/mediaSets/macosArchive">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:if test="not(@architecture)">
        <xsl:attribute name="architecture">amd64</xsl:attribute>
      </xsl:if>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="//action[
    @beanClass='com.install4j.runtime.beans.actions.misc.AddVmOptionsAction' or
    @beanClass='com.install4j.runtime.beans.actions.misc.ModifyClasspathAction'
    ]/serializedBean/property[@name='macosVmOptionsType']"/>

  <xsl:template match="//action[@failureStrategy='askQuit' or @failureStrategy='askRetryQuit']">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="failureStrategy">ask</xsl:attribute>
      <xsl:if test="@failureStrategy = 'askQuit'">
        <xsl:attribute name="failureAskRetry">false</xsl:attribute>
      </xsl:if>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="//group[@beanClass='com.install4j.runtime.beans.groups.ActionGroup']/serializedBean[
    property[@name='failureStrategy' and @value='ASK_USER']
  ]">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <property name="failureAskRetry" type="boolean" value="false" />
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="//group[@beanClass='com.install4j.runtime.beans.groups.ActionGroup']/serializedBean/property[
    @name='failureStrategy' and @value='ASK_USER_RETRY'
    ]">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="value">ASK_USER</xsl:attribute>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
</xsl:transform>
