package com.install4j.api.windows.service;

/**
 * An enum to specify service accounts. It includes the predefined system accounts.
 * @author ej-technologies GmbH
 */
public enum ServiceAccount {
    LOCAL_SYSTEM("Local System", "NT AUTHORITY\\System"),
    LOCAL_SERVICE("Local Service", "NT AUTHORITY\\LocalService"),
    NETWORK_SERVICE("Network Service", "NT AUTHORITY\\NetworkService"),
    OTHER("Other", null);

    private final String verbose;
    private final String accountName;

    ServiceAccount(String verbose, String accountName) {
        this.verbose = verbose;
        this.accountName = accountName;
    }

    @Override
    public String toString() {
        return verbose;
    }

    public String getAccountName() {
        return accountName;
    }
}