package com.install4j.api.styles;

import com.install4j.api.screens.Screen;

import javax.swing.*;

/**
 * Context object that gives access to the style-relevant properties of a screen and its content component that should
 * be embedded into the screen style component. When a new screen is activated, the {@link Style} instance receives a new
 * {@link StyleContext} instance with a call to {@link StyleContextReceiver#setStyleContext(StyleContext)}. That method is called
 * before {@link Style#createComponent()}.
 *
 * @author ej-technologies GmbH
 */
public interface StyleContext {
    /**
     * Returns the UI component of the current {@link Screen} as returned by
     * {@link Screen#createComponent()}. It is the responsibility of the screen style to embed this component
     * when {@link Style#createComponent()} is called.
     *
     * @return the UI component
     */
    JComponent getContentComponent();

    /**
     * The title of the screen as returned by {@link Screen#getTitle()}. It is the responsibility of the screen style to
     * display this title when {@link Style#createComponent()} is called.
     *
     * @return the title
     */
    String getTitle();

    /**
     * The subtitle of the screen as returned by {@link Screen#getSubTitle()}. It is the responsibility of the screen style to
     * display this subtitle when {@link Style#createComponent()} is called.
     *
     * @return the title
     */
    String getSubTitle();
}
