package com.install4j.api.styles;

import com.install4j.api.context.ControlButtonType;
import com.install4j.api.context.WizardContext;

/**
 * Implemented by form components that want to handle navigation functionality for a style.
 *
 * @author ej-technologies GmbH
 */
public interface ControlButton {
    /**
     * Called when the control button text is changed. This is called each time when a screen is activated, but it
     * can also be triggered programatically by a call to {@link WizardContext#setControlButtonText(ControlButtonType, String)}.
     *
     * @param text the text for the button
     */
    void setControlButtonText(String text);

    /**
     * Called by the framework to check the type of the control button.
     * If your form component can handle multiple {@link ControlButtonType}s, implement
     * {@link ControlButtonContainer} instead.
     *
     * @return the control button type
     */
    ControlButtonType getControlButtonType();

    /**
     * Called when the control button is focused. This is triggered programatically by a call to
     * {@link WizardContext#focusControlButton(ControlButtonType)}.
     */
    void focusControlButton();
}
