package com.install4j.api.styles;

import com.install4j.api.beans.AbstractBean;
import com.install4j.api.beans.Anchor;
import com.install4j.api.context.Context;

/**
 * Abstract base class for styles.
 * All methods that have a reasonable default answer are overridden in the class.
 * This class saves the context that is set by the framework and provides a getter for it.
 *
 * @author ej-technologies GmbH
 */
public abstract class AbstractStyle extends AbstractBean implements Style {

    private Context context;

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public void willActivate() {
    }

    @Override
    public void activated() {
    }

    @Override
    public void deactivated() {
    }

    /**
     * Returns the {@link Context} that the framework has associated with
     * this form component in {@link #setContext(Context)}.
     *
     * @return the context.
     */
    public Context getContext() {
        return context;
    }

    /**
     * Returns the {@link StyleManager}. This is a convenience method and calls
     * {@code getContext().getWizardContext().getStyleManager()}.
     *
     * @return the screen style manager
     */
    public StyleManager getStyleManager() {
        return getContext().getWizardContext().getStyleManager();
    }

    /**
     * Returns a default value for the anchor of the screen style component.
     * @return {@link Anchor#NORTHWEST}
     * @see com.install4j.api.beans.VisualContainerBean#getAnchor()
     */
    @Override
    public Anchor getAnchor() {
        return Anchor.NORTHWEST;
    }
}
