/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MonthConverter
implements ObjectConverter {
    public static ConverterContext CONTEXT_MONTH = new ConverterContext("Calendar.Month");
    private DateFormat _conciseFormat = new SimpleDateFormat("MMyy");
    private DateFormat _shortFormat = new SimpleDateFormat("MM/yy");
    private DateFormat _mediumFormat = new SimpleDateFormat("MM, yyyy");
    private DateFormat _longFormat = new SimpleDateFormat("MMMMM, yyyy");
    private DateFormat _defaultFormat = this._shortFormat;

    @Override
    public String toString(Object object, ConverterContext converterContext) {
        if (object == null || !(object instanceof Calendar)) {
            return "";
        }
        return this._defaultFormat.format(((Calendar)object).getTime());
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext converterContext) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = this._defaultFormat.parse(string);
            calendar.setTime(date);
        }
        catch (ParseException parseException) {
            try {
                Date date = this._shortFormat.parse(string);
                calendar.setTime(date);
            }
            catch (ParseException parseException2) {
                try {
                    Date date = this._mediumFormat.parse(string);
                    calendar.setTime(date);
                }
                catch (ParseException parseException3) {
                    try {
                        Date date = this._longFormat.parse(string);
                        calendar.setTime(date);
                    }
                    catch (ParseException parseException4) {
                        try {
                            Date date = this._conciseFormat.parse(string);
                            calendar.setTime(date);
                        }
                        catch (ParseException parseException5) {
                            return null;
                        }
                    }
                }
            }
        }
        return calendar;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public DateFormat getDefaultFormat() {
        return this._defaultFormat;
    }

    public void setDefaultFormat(DateFormat dateFormat) {
        this._defaultFormat = dateFormat;
    }
}

