/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ColorConverter;
import com.jidesoft.converter.ConverterContext;
import java.awt.Color;

public class HexColorConverter
extends ColorConverter {
    private boolean _alphaIncluded = false;

    public HexColorConverter() {
    }

    public HexColorConverter(boolean bl2) {
        this._alphaIncluded = bl2;
    }

    public boolean isAlphaIncluded() {
        return this._alphaIncluded;
    }

    public void setAlphaIncluded(boolean bl2) {
        this._alphaIncluded = bl2;
    }

    protected String getHexString(int n2) {
        Object object = Integer.toHexString(n2).toUpperCase();
        if (((String)object).length() == 1) {
            object = "0" + (String)object;
        }
        return object;
    }

    @Override
    public String toString(Object object, ConverterContext converterContext) {
        if (object instanceof Color) {
            Color color = (Color)object;
            StringBuffer stringBuffer = new StringBuffer("#");
            if (this.isAlphaIncluded()) {
                stringBuffer.append(this.getHexString(color.getAlpha()));
            }
            stringBuffer.append(this.getHexString(color.getRed()));
            stringBuffer.append(this.getHexString(color.getGreen()));
            stringBuffer.append(this.getHexString(color.getBlue()));
            return new String(stringBuffer);
        }
        return "";
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext converterContext) {
        long l2;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (this.isAlphaIncluded()) {
            if (string.length() > 8) {
                string = string.substring(string.length() - 8);
            }
        } else if (string.length() > 6) {
            string = string.substring(string.length() - 6);
        }
        try {
            l2 = Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Color((int)l2, this.isAlphaIncluded());
    }
}

