/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.beans.LazyUiManagerColor;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlTextPane
extends JTextPane {
    private static final Color BACKGROUND_COLOR = new LazyUiManagerColor("TextArea.background");
    private CaretTarget caretTarget;
    private Font overrideFont;

    public HtmlTextPane(CaretTarget caretTarget) {
        this.caretTarget = caretTarget;
        this.setBackground(BACKGROUND_COLOR);
        this.setEditable(false);
        this.addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                GUIHelper.showURL(event.getURL().toExternalForm());
            }
        });
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        if (caretTarget == CaretTarget.UNCHANGED) {
            caret.setUpdatePolicy(1);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.overrideFont = font;
    }

    public void updateText(String originalText) {
        String newText;
        String text = InstallerUtil.sanitizeHTML(originalText);
        try {
            newText = this.getText();
        }
        catch (Exception e) {
            newText = "";
        }
        if (!Objects.equals(newText, text)) {
            boolean html = text.toLowerCase(Locale.ENGLISH).contains("<html");
            if (html) {
                if (this.getEditorKit().getClass() != HTMLEditorKit.class) {
                    this.setEditorKit(new HTMLEditorKit());
                    Font font = this.getUsedFont();
                    StyleSheet css = ((HTMLDocument)this.getDocument()).getStyleSheet();
                    css.addRule("body {font-size : " + font.getSize() + "pt; }");
                    css.addRule("body {font-family :" + font.getFontName() + "; }");
                    this.addColorRules(css);
                }
            } else {
                if (this.getEditorKit().getClass() != StyledEditorKit.class) {
                    this.setEditorKit(new StyledEditorKit());
                }
                super.setFont(this.getUsedFont());
            }
            this.setText(text);
            if (this.caretTarget == CaretTarget.START) {
                this.setCaretPosition(0);
                this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
            }
        }
    }

    private Font getUsedFont() {
        if (this.overrideFont != null) {
            return this.overrideFont;
        }
        return UIManager.getFont("TextField.font");
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Document document = this.getDocument();
        if (document instanceof HTMLDocument) {
            StyleSheet css = ((HTMLDocument)document).getStyleSheet();
            this.addColorRules(css);
        }
    }

    private void addColorRules(StyleSheet css) {
        css.addRule("body {color : #" + GUIHelper.getHexValue(UIManager.getColor("TextArea.foreground")) + " }");
        css.addRule("body {background-color : #" + GUIHelper.getHexValue(UIManager.getColor("TextArea.background")) + "}");
    }

    public static enum CaretTarget {
        START,
        END,
        UNCHANGED;

    }
}

