/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.exe4j.runtime.util.ArgumentStack;
import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.runtime.beans.actions.services.AbstractControlServiceAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.launcher.LauncherVariables;
import com.install4j.runtime.launcher.UnixLauncher;
import com.install4j.runtime.launcher.integration.LauncherIntegration;
import com.install4j.runtime.launcher.util.ErrorHandler;
import com.install4j.runtime.launcher.util.LauncherUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacLauncher {
    public static final String CONFIG_FILENAME = "i4jlauncher.config";
    public static final String SERVICE_PROPERTY_KEY = "i4j.service";
    public static final String CONFIG_FILE_ID_KEY = "i4j.configFileId";
    public static final String SERVICE_MODE_LEGACY = "legacy";
    public static final String WORKSPACE_OPEN_PARAMETER = "__i4j_workspace_open";
    public static final String WORKSPACE_OPEN_HIDDEN_PARAMETER = "__i4j_workspace_open_hidden";
    public static final String INFO_PLIST_PATH = "/Contents/Info.plist";
    private static String exeBaseDir;
    private static volatile boolean isCommandLine;

    public static void main(String[] args) {
        LauncherIntegration.init();
        try {
            args = LauncherVariables.init(MacLauncher.class, args);
            String moduleName = System.getProperty("exe4j.moduleName");
            String configFileId = System.getProperty(CONFIG_FILE_ID_KEY);
            if (configFileId != null) {
                ErrorHandler.setIsGuiApplication(false);
                exeBaseDir = new File(moduleName).getParentFile().getAbsolutePath();
                LauncherEngine.setProperties(MacLauncher.readProperties(new File(ResourceHelper.getRuntimeDir(), "i4jlauncher.config." + configFileId).toPath()));
            } else {
                LauncherEngine.setProperties(MacLauncher.readProperties(Paths.get(moduleName + "/Contents/Resources/" + CONFIG_FILENAME, new String[0])));
                ErrorHandler.setIsGuiApplication(!LauncherEngine.getBooleanProperty(10007));
                exeBaseDir = LauncherEngine.getBooleanProperty(10006) ? moduleName + "/Contents/Resources/app/" + LauncherEngine.getProperty(10001) : moduleName + "/../";
                if (!exeBaseDir.endsWith("/")) {
                    exeBaseDir = exeBaseDir + "/";
                }
            }
            String className = LauncherEngine.getProperty(122);
            if (LauncherEngine.getBooleanProperty(133)) {
                className = "/" + className;
            }
            if (configFileId != null) {
                isCommandLine = true;
                ArgumentStack argStack = new ArgumentStack(args);
                String method = "launch";
                String serviceMode = System.getProperty(SERVICE_PROPERTY_KEY);
                if (serviceMode != null) {
                    if (serviceMode.equals(SERVICE_MODE_LEGACY)) {
                        method = argStack.popString();
                        if ("start-launchd".equals(method)) {
                            method = "start";
                        }
                    } else {
                        String serviceMethod = argStack.popString();
                        if ("stop".equals(serviceMethod)) {
                            MacLauncher.stopInstalledService(moduleName);
                        } else if ("start".equals(serviceMethod)) {
                            MacLauncher.startInstalledService(moduleName);
                        } else if ("run".equals(serviceMethod) || "run-redirect".equals(serviceMethod)) {
                            method = serviceMethod;
                        }
                    }
                }
                UnixLauncher.doStart(className, method, false, argStack);
            } else {
                String stdErrFile = UnixLauncher.getRedirectionFileName(new File(exeBaseDir), null, 102, 103);
                String stdOutFile = UnixLauncher.getRedirectionFileName(new File(exeBaseDir), null, 104, 105);
                boolean failOnMainMethodException = LauncherEngine.getBooleanProperty(106);
                SplashEngine.setJavaSplashScreenConfig(LauncherEngine.getBooleanProperty(108), new SplashScreenConfig().initFromLauncherEngine());
                LauncherEngine.launch(className, args, stdErrFile, stdOutFile, failOnMainMethodException, true, ClassLoader.getSystemClassLoader());
            }
        }
        catch (Exception e) {
            ErrorHandler.reportError(e);
            System.exit(1);
        }
    }

    public static boolean isCommandLine() {
        return isCommandLine;
    }

    private static void controlInstalledService(String moduleName, BiFunction<String, AbstractControlServiceAction.RunningState, Boolean> handler) {
        String identifier = AbstractControlServiceAction.findIdentifier(new File(moduleName), false);
        boolean success = false;
        if (identifier == null) {
            System.out.println("Did not find installed service.");
        } else {
            AbstractControlServiceAction.RunningState state = AbstractControlServiceAction.isRunningOnMac(identifier);
            success = handler.apply(identifier, state);
        }
        System.exit(success ? 0 : 1);
    }

    private static void startInstalledService(String moduleName) {
        MacLauncher.controlInstalledService(moduleName, (identifier, state) -> {
            if (state == AbstractControlServiceAction.RunningState.RUNNING) {
                System.out.println("Service is already running.");
            } else {
                System.out.println("Starting service " + identifier);
                System.out.flush();
                if (!AbstractControlServiceAction.startOnMac(identifier, false)) {
                    System.out.println("Error starting service");
                    return false;
                }
            }
            return true;
        });
    }

    private static void stopInstalledService(String moduleName) {
        MacLauncher.controlInstalledService(moduleName, (identifier, state) -> {
            if (state == AbstractControlServiceAction.RunningState.STOPPED || state == AbstractControlServiceAction.RunningState.UNKNOWN) {
                System.out.println("Service is not running.");
            } else {
                System.out.println("Stopping service " + identifier);
                System.out.flush();
                if (!AbstractControlServiceAction.stopOnMac(identifier, 30000L)) {
                    System.out.println("Error stopping service");
                    return false;
                }
            }
            return true;
        });
    }

    private static Properties readProperties(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(is);
            Properties properties2 = LauncherUtil.replaceVariables(properties);
            return properties2;
        }
    }

    @Nullable
    public static File getSingleBundleDirectory() {
        if (!Util.isMacOS() || !LauncherEngine.getBooleanProperty(10006)) {
            return null;
        }
        return FileUtil.getCanonicalFile(new File(ResourceHelper.getRuntimeDir(), "../../../.."));
    }

    public static String getMacBundleExecutablePath(File infoPlistFile) {
        if (infoPlistFile != null && infoPlistFile.isFile()) {
            try {
                String executableName = XmlHelper.getTextValue(PlistHelper.findValue(PlistHelper.getFirstChild(XmlHelper.parseFile(infoPlistFile).getDocumentElement(), "dict"), "CFBundleExecutable"));
                if (!executableName.isEmpty()) {
                    return "/Contents/MacOS/" + executableName;
                }
            }
            catch (IOException e) {
                Logger.getInstance().error(null, "Could not read Info.plist file " + infoPlistFile.getAbsolutePath());
                Logger.getInstance().log(e);
            }
        }
        return "/Contents/MacOS/JavaApplicationStub";
    }

    @NotNull
    public static File getMacBundleExecutableFile(@NotNull File bundleDir) {
        return new File(bundleDir, MacLauncher.getMacBundleExecutablePath(new File(bundleDir, INFO_PLIST_PATH)));
    }
}

