/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.ProxyHostInfo;
import com.install4j.runtime.installer.platform.win32.Common;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;

public class Win32Proxy {
    private static final boolean DEBUG = Boolean.getBoolean("install4j.debugPAC");
    private static final int WINHTTP_AUTOPROXY_AUTO_DETECT = 1;
    private static final int WINHTTP_AUTOPROXY_CONFIG_URL = 2;
    private static final int WINHTTP_AUTOPROXY_HOST_KEEPCASE = 4;
    private static final int WINHTTP_AUTOPROXY_HOST_LOWERCASE = 8;
    private static final int WINHTTP_AUTOPROXY_RUN_INPROCESS = 65536;
    private static final int WINHTTP_AUTOPROXY_RUN_OUTPROCESS_ONLY = 131072;
    private static final int WINHTTP_AUTOPROXY_NO_DIRECTACCESS = 262144;
    private static final int WINHTTP_AUTOPROXY_NO_CACHE_CLIENT = 524288;
    private static final int WINHTTP_AUTOPROXY_NO_CACHE_SVC = 0x100000;
    private static final int WINHTTP_AUTOPROXY_SORT_RESULTS = 0x400000;
    private static final int WINHTTP_AUTO_DETECT_TYPE_DHCP = 1;
    private static final int WINHTTP_AUTO_DETECT_TYPE_DNS_A = 2;
    private static boolean functionLoaded;

    private static native int getIEConfig0(String[] var0);

    private static native int getDefaultConfig0(String[] var0);

    private static native long getAutoProxyConfig0(String[] var0, String var1, String var2, int var3, int var4, boolean var5);

    private static native boolean loadFunctions0();

    private static synchronized boolean loadFunctions() {
        if (!functionLoaded) {
            if (Win32Proxy.loadFunctions0()) {
                functionLoaded = true;
            } else {
                System.err.println("could not load proxy functions");
            }
        }
        return functionLoaded;
    }

    public static ProxyHostInfo getProxyHostInfo(URL url) throws Exception {
        if (!Win32Proxy.loadFunctions()) {
            return null;
        }
        IEProxyConfig ieProxyConfig = Win32Proxy.getIEConfig();
        if (ieProxyConfig != null) {
            if (ieProxyConfig.isProxySet()) {
                return ieProxyConfig.getProxyHostInfo(url);
            }
            if (ieProxyConfig.isAutoDetect() || ieProxyConfig.getAutoConfigUrl() != null) {
                return Win32Proxy.getAutoProxyHostInfo(url, ieProxyConfig.getAutoConfigUrl());
            }
            return null;
        }
        ProxyConfig defaultConfig = Win32Proxy.getDefaultConfig();
        if (defaultConfig != null && defaultConfig.isProxySet()) {
            return defaultConfig.getProxyHostInfo(url);
        }
        if (Boolean.getBoolean("install4j.proxyAutoDetectionFallback")) {
            return Win32Proxy.getAutoProxyHostInfo(url, null);
        }
        return null;
    }

    private static ProxyHostInfo getAutoProxyHostInfo(URL url, String autoConfigUrl) {
        ProxyConfig autoProxyConfig = Win32Proxy.getAutoProxyConfig(url.toExternalForm(), autoConfigUrl);
        return autoProxyConfig == null ? null : autoProxyConfig.getProxyHostInfo(url);
    }

    private static ProxyConfig getDefaultConfig() {
        String[] data = new String[3];
        int error = Win32Proxy.getDefaultConfig0(data);
        ProxyConfig proxyConfig = null;
        if (error == 0) {
            proxyConfig = new ProxyConfig(data);
        }
        if (DEBUG) {
            Logger.getDebugInstance().info(null, "default proxy config (error " + error + "): " + proxyConfig);
        }
        return proxyConfig;
    }

    private static IEProxyConfig getIEConfig() {
        IEProxyConfig ieProxyConfig = null;
        if (!Boolean.getBoolean("install4j.proxyForceDefault")) {
            String[] data = new String[4];
            int error = Win32Proxy.getIEConfig0(data);
            if (error == 0) {
                ieProxyConfig = new IEProxyConfig(data);
            }
            if (DEBUG) {
                Logger.getDebugInstance().info(null, "IE proxy config (error " + error + "): " + ieProxyConfig);
            }
        }
        return ieProxyConfig;
    }

    private static ProxyConfig getAutoProxyConfig(String url, String pacUrl) {
        int autoDetectFlags;
        int flags;
        if (pacUrl != null) {
            flags = 2;
            autoDetectFlags = 0;
        } else {
            flags = 1;
            autoDetectFlags = Integer.getInteger("install4j.proxyAutoDetectFlags", 3);
        }
        String[] data = new String[3];
        long error = Win32Proxy.getAutoProxyConfig0(data, url, pacUrl, flags |= Integer.getInteger("install4j.proxyAdditionalFlags", 0).intValue(), autoDetectFlags, true);
        ProxyConfig autoProxyConfig = null;
        if (error == 0L) {
            autoProxyConfig = new ProxyConfig(data);
        }
        if (DEBUG) {
            Logger.getDebugInstance().info(null, "Auto proxy config (error " + Long.toHexString(error) + "): " + autoProxyConfig + ", flags " + flags + ", " + autoDetectFlags + ", url " + url + ", pac " + pacUrl);
        }
        return autoProxyConfig;
    }

    static {
        Common.init();
    }

    private static abstract class BaseProxyConfig {
        protected final String proxy;
        protected final List<String> proxyBypass;

        public BaseProxyConfig(String proxy, String bypassString) {
            this.proxy = proxy;
            this.proxyBypass = BaseProxyConfig.parseProxyBypass(bypassString);
        }

        public boolean isProxySet() {
            return this.proxy != null;
        }

        public ProxyHostInfo getProxyHostInfo(URL url) {
            if (this.proxy == null || BaseProxyConfig.isBypassed(url, this.proxyBypass)) {
                return null;
            }
            return BaseProxyConfig.getProxyHostInfo(url.getProtocol(), this.proxy);
        }

        private static ProxyHostInfo getProxyHostInfo(String protocol, String proxy) {
            String host;
            if (!(Objects.equals("http", protocol) || Objects.equals("https", protocol) || Objects.equals("ftp", protocol))) {
                protocol = "http";
            }
            proxy = BaseProxyConfig.findForProtocol(protocol, proxy);
            int port = 80;
            try {
                URL url = new URL(proxy);
                host = url.getHost();
                port = url.getPort();
            }
            catch (MalformedURLException var12) {
                int colonIndex = proxy.indexOf(":");
                if (colonIndex == -1) {
                    host = proxy;
                }
                host = proxy.substring(0, colonIndex);
                try {
                    port = Integer.parseInt(proxy.substring(colonIndex + 1));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            ProxyHostInfo proxyHostInfo = new ProxyHostInfo(host, port);
            if (DEBUG) {
                Logger.getDebugInstance().info(null, "Using proxy " + proxy + " for " + protocol + ": " + proxyHostInfo);
            }
            return proxyHostInfo;
        }

        private static String findForProtocol(String protocol, String proxy) {
            if (!(proxy = proxy.replace(' ', ';')).contains("=")) {
                int delimiterIndex = proxy.indexOf(59);
                if (delimiterIndex > -1) {
                    return proxy.substring(0, delimiterIndex);
                }
                return proxy;
            }
            StringTokenizer tokenizer = new StringTokenizer(proxy, ";");
            String httpProxy = null;
            while (tokenizer.hasMoreTokens()) {
                String singleProxy = tokenizer.nextToken();
                if (singleProxy.startsWith(protocol + "=")) {
                    return singleProxy.substring(protocol.length() + 1);
                }
                if (!singleProxy.startsWith("http=")) continue;
                httpProxy = singleProxy.substring(5);
            }
            return httpProxy;
        }

        private static List<String> parseProxyBypass(String string) {
            ArrayList<String> list = new ArrayList<String>();
            if (string != null) {
                StringTokenizer tokenizer = new StringTokenizer(string, " ;");
                while (tokenizer.hasMoreTokens()) {
                    String singleValue = tokenizer.nextToken().toLowerCase(Locale.ENGLISH).trim();
                    if (singleValue.isEmpty()) continue;
                    list.add(singleValue);
                }
            }
            return list;
        }

        private static boolean isBypassed(URL url, List<String> proxyBypass) {
            if (url != null && proxyBypass != null) {
                String host = url.getHost().toLowerCase(Locale.ENGLISH);
                for (String override : proxyBypass) {
                    if ((override = override.toLowerCase(Locale.ENGLISH)).isEmpty()) continue;
                    if (Objects.equals(override, "<local>")) {
                        if (host.contains(".")) continue;
                        if (DEBUG) {
                            Logger.getDebugInstance().info(null, "Proxy bypass: " + host + ", " + override);
                        }
                        return true;
                    }
                    if (override.startsWith("*")) {
                        if (!host.endsWith((override = override.replace('*', ' ').trim()).toLowerCase(Locale.ENGLISH))) continue;
                        if (DEBUG) {
                            Logger.getDebugInstance().info(null, "Proxy bypass: " + host + ", " + override);
                        }
                        return true;
                    }
                    if (!Objects.equals(host, override)) continue;
                    if (DEBUG) {
                        Logger.getDebugInstance().info(null, "Proxy bypass: " + host + ", " + override);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private static class ProxyConfig
    extends BaseProxyConfig {
        private final boolean proxySet;

        public ProxyConfig(String[] data) {
            super(data[1], data[2]);
            this.proxySet = Boolean.parseBoolean(data[0]);
        }

        @Override
        public boolean isProxySet() {
            return this.proxySet && super.isProxySet();
        }

        @Override
        public ProxyHostInfo getProxyHostInfo(URL url) {
            if (this.proxySet) {
                return super.getProxyHostInfo(url);
            }
            return null;
        }

        public String toString() {
            return "ProxyConfig{proxySet=" + this.proxySet + ", proxy='" + this.proxy + '\'' + ", proxyBypass=" + this.proxyBypass + '}';
        }
    }

    private static class IEProxyConfig
    extends BaseProxyConfig {
        private final boolean autoDetect;
        private final String autoConfigUrl;

        public IEProxyConfig(String[] data) {
            super(data[2], data[3]);
            this.autoDetect = Boolean.parseBoolean(data[0]);
            this.autoConfigUrl = data[1];
        }

        public boolean isAutoDetect() {
            return this.autoDetect;
        }

        public String getAutoConfigUrl() {
            return this.autoConfigUrl;
        }

        @Override
        public ProxyHostInfo getProxyHostInfo(URL url) {
            return super.getProxyHostInfo(url);
        }

        public String toString() {
            return "IEProxyConfig{autoDetect=" + this.autoDetect + ", autoConfigUrl='" + this.autoConfigUrl + '\'' + ", proxy='" + this.proxy + '\'' + ", proxyBypass='" + this.proxyBypass + '\'' + '}';
        }
    }
}

