/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.HyperlinkContainer;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.widgets.HyperlinkWidgetStyle;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.HyperlinkLabel;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class HyperlinkLabelComponent
extends LeadingLabelComponent
implements HyperlinkContainer {
    private String hyperlinkText;
    private String url;
    private String widgetStyleId = "";
    private HyperlinkWidgetStyle widgetStyle = new HyperlinkWidgetStyle();
    private HyperlinkLabel linkLabel;

    @Override
    public String getHyperlinkText() {
        return HyperlinkLabelComponent.replaceVariables(this.replaceFormVariables(this.hyperlinkText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    public void setHyperlinkText(String hyperlinkText) {
        this.hyperlinkText = hyperlinkText;
    }

    public String getUrl() {
        return HyperlinkLabelComponent.replaceVariables(this.replaceFormVariables(this.url));
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getWidgetStyleId() {
        return HyperlinkLabelComponent.replaceVariables(this.widgetStyleId);
    }

    public void setWidgetStyleId(String widgetStyleId) {
        this.widgetStyleId = widgetStyleId;
    }

    @Override
    public HyperlinkWidgetStyle getWidgetStyle() {
        return this.replaceWithTextOverride("widgetStyle", this.widgetStyle, HyperlinkWidgetStyle.class);
    }

    public void setWidgetStyle(HyperlinkWidgetStyle widgetStyle) {
        this.widgetStyle = widgetStyle;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initializeHyperlinkLabel(this.linkLabel, this);
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.linkLabel != null && formEnvironment != null) {
            this.linkLabel.setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.linkLabel = new HyperlinkLabel(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HyperlinkLabelComponent.this.doHyperlink();
            }
        });
        return this.linkLabel;
    }

    private void doHyperlink() {
        if (this.getFormEnvironment().isDesignTime()) {
            return;
        }
        String url = this.getUrl();
        if (url.isEmpty()) {
            return;
        }
        try {
            URL realUrl = new URL(url);
            Util.showUrl(realUrl);
        }
        catch (MalformedURLException e) {
            Util.showErrorMessage(Messages.formatString(".InvalidUrl", url));
        }
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return false;
    }

    @Override
    public Object getConfigurationObject() {
        return this.linkLabel;
    }

    @Override
    public Class<?> getConfigurationObjectClass() {
        return JLabel.class;
    }

    @Override
    public boolean handleConsole(Console console) {
        String url = this.getUrl();
        String hyperlinkText = this.getHyperlinkText();
        if (hyperlinkText != null && !Objects.equals(hyperlinkText, url)) {
            console.println(hyperlinkText + " " + url);
        } else {
            console.println(url);
        }
        return true;
    }
}

