/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client;

import com.github.davidmoten.aws.lw.client.Formats;
import com.github.davidmoten.aws.lw.client.Metadata;
import com.github.davidmoten.aws.lw.client.ServiceException;
import com.github.davidmoten.aws.lw.client.internal.util.Preconditions;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Response {
    private final Map<String, List<String>> headers;
    private final Map<String, List<String>> headersLowerCaseKey;
    private final byte[] content;
    private final int statusCode;

    public Response(Map<String, List<String>> headers, byte[] content, int statusCode) {
        this.headers = headers;
        this.headersLowerCaseKey = Response.lowerCaseKey(headers);
        this.content = content;
        this.statusCode = statusCode;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Map<String, List<String>> headersLowerCaseKey() {
        return this.headersLowerCaseKey;
    }

    public Optional<String> firstHeader(String name) {
        List<String> h = this.headersLowerCaseKey.get(Response.lowerCase(name));
        if (h == null || h.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(h.get(0));
    }

    public Optional<Instant> firstHeaderFullDate(String name) {
        return this.firstHeader(name).map(x -> ZonedDateTime.parse(x, Formats.FULL_DATE).toInstant());
    }

    public Metadata metadata() {
        return new Metadata(this.headersLowerCaseKey.entrySet().stream().filter(x -> x.getKey() != null).filter(x -> ((String)x.getKey()).startsWith("x-amz-meta-")).collect(Collectors.toMap(x -> ((String)x.getKey()).substring(11), x -> (String)((List)x.getValue()).get(0))));
    }

    public Optional<String> metadata(String name) {
        Preconditions.checkNotNull(name);
        return this.metadata().value(name);
    }

    public byte[] content() {
        return this.content;
    }

    public String contentUtf8() {
        return new String(this.content, StandardCharsets.UTF_8);
    }

    public int statusCode() {
        return this.statusCode;
    }

    public boolean isOk() {
        return this.statusCode >= 200 && this.statusCode <= 299;
    }

    public boolean exists() {
        if (this.statusCode >= 200 && this.statusCode <= 299) {
            return true;
        }
        if (this.statusCode == 404) {
            return false;
        }
        throw new ServiceException(this.statusCode, "call failed");
    }

    private static Map<String, List<String>> lowerCaseKey(Map<String, List<String>> m) {
        return m.entrySet().stream().collect(Collectors.toMap(entry -> Response.lowerCase((String)entry.getKey()), entry -> (List)entry.getValue()));
    }

    private static String lowerCase(String s) {
        return s == null ? s : s.toLowerCase(Locale.ENGLISH);
    }
}

