package com.install4j.api.windows;

import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;

import java.io.File;

/**
 * Collection of methods regarding the UAC elevation state on Windows Vista or higher.

 * @author ej-technologies GmbH
 */
public class Elevation {

    /**
     * Returns the elevation state of the current process.
     * @return the elevation state or {@code null} if not called on Windows.
     */
    public static ElevationState getElevationState() {
        if (!Util.isWindows()) return null;
        return ElevationState.getFromIntValue(Win32UserInfo.getElevationType());
    }

    /**
     * Runs an executable in the elevated state. Blocks until all UAC dialogs have been answered.
     *
     * @param executable the executable
     * @param parameters parameters passed to the executable. Can be {@code null}.
     * @param directory The working directory for the process. If {@code null} the current working directory is used.
     * @return false if the process cannot be started. Includes a canceled UAC request.
     */
    public static boolean executeElevated(File executable, String parameters, File directory) {
        if (!Util.isWindows()) return false;
        return Win32UserInfo.executeElevated(executable.getAbsolutePath(), parameters, directory != null ? directory.getAbsolutePath() : null);
    }


    private Elevation() {
    }
}
