package com.install4j.api.styles;

import com.install4j.api.context.ControlButtonType;
import com.install4j.api.context.WizardContext;
import com.install4j.api.formcomponents.FormComponent;

/**
 * Implemented by objects that handle navigation functionality. All {@link Style} instances implement this interface,
 * but a {@link FormComponent} can also implement it. In that case, the interface methods are only called if the form
 * component is used in a style. If a form component only wants to handle a single control button type, it should
 * implement {@link ControlButtonType} instead.
 *
 * @author ej-technologies GmbH
 */
public interface ControlButtonContainer {

    /**
     * Called when the enabled state of a control button is changed. This is called by the framework as required,
     * but it can also be triggered programatically by a call to
     * {@link WizardContext#setControlButtonEnabled(ControlButtonType, boolean)}.
     *
     * @param controlButtonType the control button type
     * @param enabled           {@code true} or {@code false}
     */
    void setControlButtonEnabled(ControlButtonType controlButtonType, boolean enabled);

    /**
     * Called when the visibility of a control button is changed. This is called by the framework as required,
     * but it can also be triggered programatically by a call to
     * {@link WizardContext#setControlButtonVisible(ControlButtonType, boolean)}.
     *
     * @param controlButtonType the control button type
     * @param visible           {@code true} or {@code false}
     */
    void setControlButtonVisible(ControlButtonType controlButtonType, boolean visible);

    /**
     * Called when a control button text is changed. This is called for all control button types each time when
     * a screen is activated, but it can also be triggered programatically by a call to
     * {@link WizardContext#setControlButtonText(ControlButtonType, String)}.
     *
     * @param controlButtonType the control button type
     * @param text              the text for the button
     */
    void setControlButtonText(ControlButtonType controlButtonType, String text);

    /**
     * Called when a control button is focused. This is triggered programatically by a call to
     * {@link WizardContext#focusControlButton(ControlButtonType)}.
     */
    void focusControlButton(ControlButtonType controlButtonType);
}
