package com.install4j.api.events;

import com.install4j.api.context.Context;

import java.io.File;

/**
 * The event object that is passed to installer event listeners for the directory creation event.
 * Event listeners are registered in the {@link com.install4j.api.context.InstallerContext}.
 * <p>This event object contains additional information about the installed file.
 * The event type {@link EventType#DIRECTORY_CREATED}
 * produces this event object when fired.
 * @author ej-technologies GmbH
 * @see InstallerEventListener
 * @see com.install4j.api.context.InstallerContext#addInstallerEventListener(InstallerEventListener)
 *
 */
public class InstallerDirectoryEvent extends InstallerEvent {
    private File directory;

    /**
     * The constructor is called by the framework.
     * @param source the event source
     * @param context the context
     * @param type the event type.
     * @param success whether the operation associated with the event was successful
     * @param directory the installed file
     */
    public InstallerDirectoryEvent(Object source, Context context, EventType type, boolean success, File directory) {
        super(source, context, type, success);
        this.directory = directory;
    }

    /**
     * Get the created directory associated with this event.
     * @return the file
     */
    public File getDirectory() {
        return directory;
    }

    @Override
    public String toString() {
        return super.toString() + " [directory " + directory +  "]";
    }

    @Override
    public String getVerbose() {
        String ret = super.getVerbose() + ": " + directory;
        if (getType() == EventType.DIRECTORY_CREATED) {
            ret += "; exists: " + directory.exists();
        }
        return ret;
    }
}
