package com.install4j.api.context;

import java.io.Serializable;

/**
 * On macOS and Windows Vista and higher, the 'require admin user' action can spawn additional installation processes that have full admin rights.
 * If you have selected to elevate the main installation process, you can implement this interface and pass it to
 * {@link Context#runUnelevated} to run code in the context of the original user account.
 * Otherwise {@link Context#runElevated} can be used to execute something with full admin rights.
 * All implementations must be fully serializable.
 *
 * @author ej-technologies GmbH
 * @see Context#runUnelevated
 * @see Context#runElevated
 */
public interface RemoteCallable extends Serializable {
    /**
     * The method that will be executed within the requested account.
     *
     * @return You can return any serializable object that will be passed back by {@link Context#runUnelevated} or {@link Context#runElevated}
     */
    Serializable execute();
}
