package com.install4j.api.context;

import java.io.File;

/**
 * Default implementation of {@link UnattendedProgressInterface UnattendedProgressInterface}.
 * You can override its methods to customize the default behavior.
 * @author ej-technologies GmbH
 */
public class DefaultUnattendedProgressInterface implements UnattendedProgressInterface {

    private int percentCompleted;

    /**
     * Default implementation for unattended mode that does nothing.
     * @param visible {@code true} at startup and {@code false} at exit
     */
    @Override
    public void setVisible(boolean visible) {
    }

    /**
     * Default implementation for unattended mode that does nothing.
     * @param enabled {@code true} or {@code false}
     */
    @Override
    public void setCancelButtonEnabled(boolean enabled) {
    }

    /**
     * Default implementation for unattended mode that does nothing.
     * @param visible {@code true} or {@code false}
     */
    @Override
    public void setCancelButtonVisible(boolean visible) {
    }

    /**
     * Default implementation for unattended mode that does nothing.
     * @param message the new message.
     */
    @Override
    public void setStatusMessage(String message) {
    }

    /**
     * Default implementation for unattended mode that does nothing.
     * @param message the new message.
     */
    @Override
    public void setDetailMessage(String message) {
    }

    /**
     * Sets the completion percentage of the current action and saves it to a local variable.
     * @param value a value between 0 and 100.
     */
    @Override
    public void setPercentCompleted(int value) {
        this.percentCompleted = value;
    }

    /**
     * Returns the last value set by {@link #setPercentCompleted(int) setPercentCompleted}.
      * @return the percentage of completion
     */
    @Override
    public int getPercentCompleted() {
        return percentCompleted;
    }

    @Override
    public void setSecondaryPercentCompleted(int value) {

    }

    /**
     * Default implementation for unattended mode that does nothing.
     * @param indeterminateProgress {@code true} or {@code false}
     */
    @Override
    public void setIndeterminateProgress(boolean indeterminateProgress) {
    }

    /**
     * Default implementation for unattended mode that does nothing.
     * @param message the error message
     */
    @Override
    public void showFailure(String message) {
    }

    /**
     * Default implementation for unattended mode.
     * @param file the file in question.
     * @return always returns {@link #OVERWRITE_NO OVERWRITE_NO}
     * @throws UserCanceledException if the user cancels the operation
     */
    @Override
    public int askOverwrite(File file) throws UserCanceledException {
        return OVERWRITE_NO;
    }

    /**
     * Default implementation for unattended mode.
     * @param file the file in question.
     * @return always returns {@link #RETRY_NO RETRY_NO}
     * @throws UserCanceledException if the user cancels the operation
     */
    @Override
    public int askRetry(File file) throws UserCanceledException {
        return RETRY_NO;
    }

    /**
     * Default implementation for unattended mode.
     * @param file the file in question.
     * @return always returns {@code true}
     * @throws UserCanceledException if the user cancels the operation
     */
    @Override
    public boolean askContinue(File file) throws UserCanceledException {
        return true;
    }
}
