package com.install4j.api.beans;

import java.awt.*;

/**
 * Property type for an anchor.
 *
 * @author ej-technologies GmbH
 */

public enum Anchor {

    NORTHWEST("North-West", GridBagConstraints.FIRST_LINE_START, true),
    NORTH("North", GridBagConstraints.PAGE_START, false),
    NORTHEAST("North-East", GridBagConstraints.FIRST_LINE_END, true),
    WEST("West", GridBagConstraints.LINE_START, false),
    CENTER("Center", GridBagConstraints.CENTER, false),
    EAST("East", GridBagConstraints.LINE_END, false),
    SOUTHWEST("South-West", GridBagConstraints.LAST_LINE_START, true),
    SOUTH("South", GridBagConstraints.PAGE_END, false),
    SOUTHEAST("South-East", GridBagConstraints.LAST_LINE_END, true);

    /**
     * Get the anchor constant that corresponds to the specified value
     * @param value the value, as returned by {@link #getValue()}
     * @see #getValue()
     * @return the anchor or {@code null} if the value cannot be found
     */
    public static Anchor getByValue(int value) {
        for (Anchor anchor : values()) {
            if (anchor.getValue() == value) {
                return anchor;
            }
        }
        return null;
    }

    private final String verbose;
    private final int value;
    private final boolean corner;

    Anchor(String verbose, int value, boolean corner) {
        this.verbose = verbose;
        this.value = value;
        this.corner = corner;
    }

    /**
     * If the anchor is a corner.
     * @return the value
     */
    public boolean isCorner() {
        return corner;
    }
    /**
     * The value of the anchor which can be used by {@code java.awt.GridBagLayout}.
     * @return the value, one of the anchor constants in {@code java.awt.GridBagConstraints}
     */
    public int getValue() {
        return value;
    }

    @Override
    public String toString() {
        return verbose;
    }

}
