package com.install4j.api.beaninfo;

import javax.swing.*;

/**
 * Enumeration class for all possible file selection modes for file property descriptors.
 * @see FilePropertyDescriptor#create(String, Class, String, String, FileSelectionMode, String[], String)
 */
public enum FileSelectionMode {

    /**
     * Only show files in the file chooser.
     */
    FILES_ONLY(JFileChooser.FILES_ONLY),

    /**
     * Only show directories in the file chooser.
     */
    DIRECTORIES_ONLY(JFileChooser.DIRECTORIES_ONLY),

    /**
     * Show both files and directories in the file chooser.
     */
    FILES_AND_DIRECTORIES(JFileChooser.FILES_AND_DIRECTORIES);

    private final int mode;

    FileSelectionMode(int mode) {
        this.mode = mode;
    }

    /**
     * Convert to an int value.
     * @return the int value
     */
    public int getJFileChooserMode() {
        return mode;
    }

}
