package com.install4j.api;

import com.install4j.runtime.installer.helper.apiimpl.SystemInfoImpl;

import java.io.File;

/**
 * The class contains utility functions to get information about the current system
 * that is not available via the Java API. 
 * @author ej-technologies GmbH
 */
public class SystemInfo {

    /**
     * Retrieves the free disk space for the disk containing the given file on Windows, macOS and Linux.
     * @param file the file or directory to check the disk space for
     * @return the free disk space in bytes. -1 if the information is not available.
     */
    public static long getFreeDiskSpace(File file) {
        return SystemInfoImpl.getFreeDiskSpace(file);
    }

    /**
     * Retrieves the physical memory on Windows, macOS and Linux.
     * @return the physical memory in bytes. Zero if the information is not available.
     */
    public static long getPhysicalMemory() {
        return SystemInfoImpl.getPhysicalMemory();
    }

}
