/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.extensions.json;

import com.install4j.api.Util;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.extensions.json.JsonModificationType;
import com.install4j.extensions.json.JsonValueSource;
import com.install4j.extensions.shadow.com.jayway.jsonpath.Configuration;
import com.install4j.extensions.shadow.com.jayway.jsonpath.DocumentContext;
import com.install4j.extensions.shadow.com.jayway.jsonpath.JsonPath;
import com.install4j.extensions.shadow.com.jayway.jsonpath.JsonPathException;
import com.install4j.extensions.shadow.com.jayway.jsonpath.Option;
import com.install4j.extensions.shadow.com.jayway.jsonpath.Predicate;
import com.install4j.runtime.beans.actions.files.AbstractModifyMultipleFilesAction;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ModifyJsonPathAction
extends AbstractModifyMultipleFilesAction
implements PropertyLoggingInterceptor {
    private String jsonPath = "";
    private JsonModificationType modificationType = JsonModificationType.SET_VALUES;
    private JsonValueSource jsonValueSource = JsonValueSource.TEXT;
    private String jsonValueText = "";
    private boolean logReplacement = true;
    private String jsonValueVariableName = "";
    private String keyName = "";
    private String newKeyName = "";
    private ScriptProperty replaceScript;
    private boolean failIfNoReplacement = false;

    public String getJsonPath() {
        return ModifyJsonPathAction.replaceVariables((String)this.jsonPath);
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public JsonModificationType getModificationType() {
        return (JsonModificationType)((Object)this.replaceWithTextOverride("modificationType", (Object)this.modificationType, JsonModificationType.class));
    }

    public void setModificationType(JsonModificationType modificationType) {
        this.modificationType = modificationType;
    }

    public JsonValueSource getJsonValueSource() {
        return (JsonValueSource)((Object)this.replaceWithTextOverride("jsonValueSource", (Object)this.jsonValueSource, JsonValueSource.class));
    }

    public void setJsonValueSource(JsonValueSource jsonValueSource) {
        this.jsonValueSource = jsonValueSource;
    }

    public String getJsonValueText() {
        return ModifyJsonPathAction.replaceVariables((String)this.jsonValueText);
    }

    public void setJsonValueText(String jsonValueText) {
        this.jsonValueText = jsonValueText;
    }

    public boolean isLogReplacement() {
        return this.replaceWithTextOverride("logReplacement", this.logReplacement);
    }

    public void setLogReplacement(boolean logReplacement) {
        this.logReplacement = logReplacement;
    }

    public String getJsonValueVariableName() {
        return ModifyJsonPathAction.replaceVariables((String)this.jsonValueVariableName);
    }

    public void setJsonValueVariableName(String jsonValueVariableName) {
        this.jsonValueVariableName = jsonValueVariableName;
    }

    public String getKeyName() {
        return ModifyJsonPathAction.replaceVariables((String)this.keyName);
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getNewKeyName() {
        return ModifyJsonPathAction.replaceVariables((String)this.newKeyName);
    }

    public void setNewKeyName(String newKeyName) {
        this.newKeyName = newKeyName;
    }

    public ScriptProperty getReplaceScript() {
        return (ScriptProperty)this.replaceWithTextOverride("replaceScript", this.replaceScript, ScriptProperty.class);
    }

    public void setReplaceScript(ScriptProperty replaceScript) {
        this.replaceScript = replaceScript;
    }

    public boolean isFailIfNoReplacement() {
        return this.replaceWithTextOverride("failIfNoReplacement", this.failIfNoReplacement);
    }

    public void setFailIfNoReplacement(boolean failIfNoReplacement) {
        this.failIfNoReplacement = failIfNoReplacement;
    }

    public Object getLogValueForProperty(String propertyName, Object propertyValue) {
        return this.maybeFilterLogReplacement(propertyName, "jsonValueText", propertyValue, this.isLogReplacement());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean modifyFile(File file, Context context) throws IOException, UserCanceledException {
        DocumentContext documentContext = JsonPath.using(Configuration.defaultConfiguration().addOptions(Option.SUPPRESS_EXCEPTIONS)).parse(file);
        String fileContent = documentContext.jsonString();
        boolean success = this.modifyFileContent(documentContext, context);
        if (!success) {
            return false;
        }
        String newFileContent = documentContext.jsonString();
        if (fileContent.equals(newFileContent) && this.isFailIfNoReplacement()) {
            Logger.getInstance().log((Object)this, "No modification has been made for " + file, false);
            return false;
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(newFileContent);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Logger.getInstance().log((Object)this, "Could not write " + file + ": " + e.getMessage(), false);
            return false;
        }
    }

    private boolean modifyFileContent(DocumentContext documentContext, Context context) throws IOException {
        try {
            JsonModificationType modificationType = this.getModificationType();
            switch (modificationType) {
                case SET_VALUES: {
                    return this.setValues(documentContext, context);
                }
                case REPLACE_VALUES: {
                    return this.replaceValues(documentContext, context);
                }
                case ADD_TO_ARRAYS: {
                    return this.addToArrays(documentContext, context);
                }
                case DELETE_VALUES: {
                    return this.deleteValues(documentContext);
                }
                case ADD_OR_UPDATE_KEYS: {
                    return this.addOrUpdateKeys(documentContext, context);
                }
                case RENAME_KEYS: {
                    return this.renameKeys(documentContext);
                }
            }
            throw new IllegalStateException(modificationType.toString());
        }
        catch (JsonPathException e) {
            Logger.getInstance().log((Object)this, "JSONPath error: " + e.getMessage(), false);
            return false;
        }
    }

    private boolean setValues(DocumentContext documentContext, Context context) throws IOException {
        Object value = this.getValue(context);
        if (value != null) {
            documentContext.set(this.getJsonPath(), value, new Predicate[0]);
            return true;
        }
        return false;
    }

    private boolean replaceValues(DocumentContext documentContext, Context context) throws IOException {
        try {
            documentContext.map(this.getJsonPath(), (currentValue, configuration) -> {
                try {
                    return context.runScript(this.getReplaceScript(), (Bean)this, new Object[]{currentValue});
                }
                catch (Exception e) {
                    Util.printAnnotatedStackTrace((Throwable)e);
                    Logger.getInstance().log((Throwable)e);
                    throw new JsonScriptException();
                }
            }, new Predicate[0]);
            return true;
        }
        catch (JsonScriptException e) {
            return false;
        }
    }

    private boolean addToArrays(DocumentContext documentContext, Context context) throws IOException {
        Object value = this.getValue(context);
        if (value != null) {
            documentContext.add(this.getJsonPath(), value, new Predicate[0]);
            return true;
        }
        return false;
    }

    private boolean deleteValues(DocumentContext documentContext) throws IOException {
        documentContext.delete(this.getJsonPath(), new Predicate[0]);
        return true;
    }

    private boolean addOrUpdateKeys(DocumentContext documentContext, Context context) throws IOException {
        Object value = this.getValue(context);
        if (value != null) {
            documentContext.put(this.getJsonPath(), this.getKeyName(), value, new Predicate[0]);
            return true;
        }
        return false;
    }

    private boolean renameKeys(DocumentContext documentContext) throws IOException {
        documentContext.renameKey(this.getJsonPath(), this.getKeyName(), this.getNewKeyName(), new Predicate[0]);
        return true;
    }

    @Nullable
    private Object getValue(Context context) {
        JsonValueSource jsonValueSource = this.getJsonValueSource();
        switch (jsonValueSource) {
            case TEXT: {
                return JsonPath.parse(this.getJsonValueText()).json();
            }
            case VARIABLE: {
                Object variableValue = context.getVariable(this.getJsonValueVariableName());
                if (variableValue instanceof Map || variableValue instanceof List) {
                    return variableValue;
                }
                if (variableValue instanceof String) {
                    return JsonPath.parse((String)variableValue).json();
                }
                Logger.getInstance().log((Object)this, "The variable " + this.getJsonValueVariableName() + " does not contain a JSON value", false);
                return null;
            }
        }
        throw new IllegalStateException(jsonValueSource.toString());
    }

    private static class JsonScriptException
    extends RuntimeException {
        private JsonScriptException() {
        }
    }
}

