/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import com.google.common.base.Joiner;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.Install4JBeanInfo;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.net.AbstractHttpRequestAction;
import com.install4j.runtime.beans.actions.net.AbstractHttpRequestActionBeanInfo;
import com.install4j.runtime.beans.actions.net.HttpRequestAction;
import com.install4j.runtime.beans.actions.net.HttpRequestMethod;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import com.install4j.runtime.beans.mappers.KeyValuePairsListPropertyConverter;
import com.install4j.runtime.beans.propertycustomizers.FormDataCustomizer;
import java.util.Map;

@BeanInfo
public class HttpRequestActionBeanInfo
extends AbstractHttpRequestActionBeanInfo {
    private static final String PROPERTY_REQUEST_METHOD = "requestMethod";
    private static final String FORM_DATA = "formData";
    private static final String PROPERTY_RESPONSE_VARIABLE_NAME = "responseVariableName";
    private static final String PROPERTY_RESPONSE_CODE_VARIABLE_NAME = "responseCodeVariableName";
    private static final String CONTEXT_KEY_VALUE_PAIRS = "keyValuePairs";
    private static final String PROPERTY_RESPONSE_HEADERS_VARIABLE_NAME = "responseHeadersVariableName";
    private static final String PROPERTY_PERFORM_ROLLBACK_REQUEST = "performRollbackRequest";
    private static final String PROPERTY_ROLLBACK_URL = "rollbackUrl";
    private static final String PROPERTY_ROLLBACK_REQUEST_METHOD = "rollbackRequestMethod";
    private static final String PROPERTY_ROLLBACK_FORM_DATA = "rollbackFormData";
    private static final String PROPERTY_USE_REQUEST_BODY = "useRequestBody";
    private static final String PROPERTY_REQUEST_BODY_CONTENT_TYPE = "requestBodyContentType";
    private static final String PROPERTY_REQUEST_BODY = "requestBody";
    private static final String PROPERTY_USE_ROLLBACK_REQUEST_BODY = "useRollbackRequestBody";
    private static final String PROPERTY_ROLLBACK_REQUEST_BODY_CONTENT_TYPE = "rollbackRequestBodyContentType";
    private static final String PROPERTY_ROLLBACK_REQUEST_BODY = "rollbackRequestBody";

    public HttpRequestActionBeanInfo() {
        super("HTTP request", "Make an HTTP request to a specified URL. All common HTTP request methods are supported for REST calls. For mime types starting with <tt>text</tt> or containing \"charset\" information, the response body can be saved to an installer variable. To download large files, use the \"Download file\" action instead.<p>The action will succeed if an HTTP response code in the 2xx range is received, otherwise it will fail. You can save the response code to a variable to inspect it in a later action.</p>", "HTTP and network", true, false, (Integer)null, (Class<? extends AbstractHttpRequestAction>)HttpRequestAction.class);
        this.addPropertyDescriptor(this.categoryResponse(Install4JPropertyDescriptor.create((String)PROPERTY_RESPONSE_VARIABLE_NAME, (Class)this.getBeanClass(), (String)"Variable name for response body", (String)"Optionally, you can enter a variable name that will be set with the text of the response body as an instance of <tt>java.lang.String</tt>. The variable value will not be written to the log file.Enter the variable without the installer prefix and the dollar sign.<p>The variable will not be set if the mime type does not start with <tt>text/</tt> or contain \"charset\" information.</p>", (String)"variableName").setVariableValueClass(String.class)));
        this.addPropertyDescriptor(this.categoryResponse(Install4JPropertyDescriptor.create((String)PROPERTY_RESPONSE_CODE_VARIABLE_NAME, (Class)this.getBeanClass(), (String)"Variable name for response code", (String)"Optionally, you can enter a variable name that will be set with the response code as an instance of <tt>java.lang.Integer</tt>. Enter the variable without the installer prefix and the dollar sign.", (String)"variableName").setVariableValueClass(Integer.class)));
        this.addPropertyDescriptor(this.categoryResponse(Install4JPropertyDescriptor.create((String)PROPERTY_RESPONSE_HEADERS_VARIABLE_NAME, (Class)this.getBeanClass(), (String)"Variable name for response headers", (String)"Optionally, you can enter a variable name that will be set with the response headers as an instance of <tt>java.util.Map</tt>. The keys in the map are the header names, and the values are instances of <tt>java.util.List&lt;String&gt;</tt> with the header values. The variable value will not be written to the log file.Enter the variable without the installer prefix and the dollar sign.", (String)"variableName").setVariableValueClass(Map.class)));
    }

    @Override
    protected String getUrlShortDescription() {
        return "The URL for the HTTP request. The URL must start with <tt>http://</tt> or <tt>https://</tt>. If you add a query string, it must already be URL encoded.<p>To post a query string with URL-encoded key-value pairs, use the \"Form data\" property instead of adding the query string here.</p>";
    }

    @Override
    protected void addRequestProperties() {
        String string = "The request method for the HTTP protocol can be one of " + Joiner.on((String)", ").join((Object[])HttpRequestMethod.values()) + ". For " + String.valueOf(HttpRequestMethod.POST) + " and " + String.valueOf(HttpRequestMethod.PUT) + ", the values entered in the \"Form data\" property are transmitted in the HTTP message body with the mime type \"application/x-www-form-urlencoded\". For other request methods, the data is appended as a query string to the URL.";
        this.addPropertyDescriptor(this.categoryRequest(Install4JPropertyDescriptor.create((String)PROPERTY_REQUEST_METHOD, (Class)this.getBeanClass(), (String)"HTTP request method", (String)string)));
        this.addRequestBodyProperties(PROPERTY_REQUEST_METHOD, PROPERTY_USE_REQUEST_BODY, PROPERTY_REQUEST_BODY_CONTENT_TYPE, PROPERTY_REQUEST_BODY);
        String string2 = "A list of key-value pairs that should be transmitted with this request. Depending on the request method, they are either appended as a query string to the URL or transmitted in the HTTP message body.<p>" + BeanInfoUtil.getArrayExpansionHelp("key-value pairs") + "</p>";
        this.addPropertyDescriptor(this.categoryRequest(Install4JPropertyDescriptor.create((String)FORM_DATA, (Class)this.getBeanClass(), (String)"Form data", (String)string2, (String)CONTEXT_KEY_VALUE_PAIRS)));
        super.addRequestProperties();
        this.addPropertyDescriptor(this.categoryRequest(Install4JPropertyDescriptor.create((String)PROPERTY_PERFORM_ROLLBACK_REQUEST, (Class)this.getBeanClass(), (String)"Perform rollback request", (String)"If selected, a request is performed in case of a rollback.  You can configure the rollback request with the child properties. All other properties, such as error handling are shared with the regular request.").setActionListHiddenKeys(new String[]{"noRollback"})));
        this.addPropertyDescriptor(this.reparentRollback(Install4JPropertyDescriptor.create((String)PROPERTY_ROLLBACK_URL, (Class)this.getBeanClass(), (String)"Rollback URL", (String)"The URL for the rollback request. The URL must start with <tt>http://</tt> or <tt>https://</tt>. If you add a query string, it must already be URL encoded.")));
        this.addPropertyDescriptor(this.reparentRollback(Install4JPropertyDescriptor.create((String)PROPERTY_ROLLBACK_REQUEST_METHOD, (Class)this.getBeanClass(), (String)"Rollback HTTP request method", (String)string)));
        this.addRequestBodyProperties(PROPERTY_ROLLBACK_REQUEST_METHOD, PROPERTY_USE_ROLLBACK_REQUEST_BODY, PROPERTY_ROLLBACK_REQUEST_BODY_CONTENT_TYPE, PROPERTY_ROLLBACK_REQUEST_BODY);
        this.addPropertyDescriptor(this.reparentRollback(Install4JPropertyDescriptor.create((String)PROPERTY_ROLLBACK_FORM_DATA, (Class)this.getBeanClass(), (String)"Rollback form data", (String)string2, (String)CONTEXT_KEY_VALUE_PAIRS)));
        BeanInfoUtil.addPropertyConverters(new KeyValuePairsListPropertyConverter(CONTEXT_KEY_VALUE_PAIRS, FormDataCustomizer.class), (Install4JBeanInfo)this);
    }

    private void addRequestBodyProperties(String string, String string2, String string3, String string4) {
        this.addPropertyDescriptor(this.reparentRequestMethod(string, Install4JPropertyDescriptor.create((String)string2, (Class)this.getBeanClass(), (String)"Custom request body", (String)"If selected, a custom request body is sent. For form data, use the \"Form data\" property instead. If both form data and a custom request body are present, the form data is appended to the URL.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(string2, Install4JPropertyDescriptor.create((String)string3, (Class)this.getBeanClass(), (String)"Content type", (String)"The content type of the request body. For JSON, use <tt>application/json</tt>.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(string2, Install4JPropertyDescriptor.create((String)string4, (Class)this.getBeanClass(), (String)"Request body", (String)"The request body as a string.", (String)"multiline")));
    }

    private Install4JPropertyDescriptor reparentRequestMethod(String string, Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setParentProperty(string);
        install4JPropertyDescriptor.setVisibilityDiscriminator((bean, object) -> {
            HttpRequestMethod httpRequestMethod = (HttpRequestMethod)object;
            return httpRequestMethod != null && httpRequestMethod.isBodyFormData();
        });
        return install4JPropertyDescriptor;
    }

    private Install4JPropertyDescriptor reparentRollback(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setParentProperty(PROPERTY_PERFORM_ROLLBACK_REQUEST);
        return install4JPropertyDescriptor;
    }

    @Override
    protected Install4JPropertyDescriptor categoryRequest(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("Request");
        return install4JPropertyDescriptor;
    }

    private Install4JPropertyDescriptor categoryResponse(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("Response");
        return install4JPropertyDescriptor;
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        HttpRequestAction httpRequestAction = (HttpRequestAction)bean;
        if (httpRequestAction.isPerformRollbackRequest()) {
            this.checkNotEmpty(PROPERTY_ROLLBACK_URL, bean);
            BeanInfoUtil.checkUrl(PROPERTY_ROLLBACK_URL, (Install4JBeanInfo)this, bean);
        }
        if (httpRequestAction.isUseRequestBody()) {
            this.checkNotEmpty(PROPERTY_REQUEST_BODY_CONTENT_TYPE, bean);
            this.checkNotEmpty(PROPERTY_REQUEST_BODY, bean);
        }
        if (httpRequestAction.isUseRollbackRequestBody()) {
            this.checkNotEmpty(PROPERTY_ROLLBACK_REQUEST_BODY_CONTENT_TYPE, bean);
            this.checkNotEmpty(PROPERTY_ROLLBACK_REQUEST_BODY, bean);
        }
    }
}

