/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.jdbc;

import com.install4j.api.actions.Action;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.FailureStrategy;
import com.install4j.runtime.beans.actions.jdbc.AbstractJdbcActionBeanInfo;
import com.install4j.runtime.beans.actions.jdbc.CheckJdbcConnectionAction;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import java.util.List;

@BeanInfo
public class CheckJdbcConnectionActionBeanInfo
extends AbstractJdbcActionBeanInfo {
    private static final String PROPERTY_USE_CUSTOM_CHECK_SQL = "useCustomCheckSql";
    private static final String PROPERTY_CUSTOM_CHECK_SQL = "customCheckSql";

    public CheckJdbcConnectionActionBeanInfo() {
        super("Check JDBC connection", "Check if a connection can be made to the configured JDBC database. If no connection can be made, the action will fail. If the action is attached to a form screen that queries a database location, set its \"Error message\" property to an appropriate error message and the \"Failure strategy\" property to \"" + String.valueOf(FailureStrategy.RETURN_TO_SCREEN) + "\".", CheckJdbcConnectionAction.class);
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_USE_CUSTOM_CHECK_SQL, (Class)this.getBeanClass(), (String)"Use a custom SQL query", (String)"By default, the action executes \"select 1 from dual\" for Oracle databases and \"select 1\" for other databases. If you would like to use another statement, select this property."));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_USE_CUSTOM_CHECK_SQL, Install4JPropertyDescriptor.create((String)PROPERTY_CUSTOM_CHECK_SQL, (Class)this.getBeanClass(), (String)"Custom SQL query", (String)"An SQL query that returns at least one row. If the statement fails or of it returns zero rows, the action will fail.")));
        this.addErrorMessagesVariableNameProperty();
    }

    @Override
    public void validateAction(Action action, List<String> list) throws BeanValidationException {
        super.validateAction(action, list);
        if (((CheckJdbcConnectionAction)action).isUseCustomCheckSql()) {
            this.checkNotEmpty(PROPERTY_CUSTOM_CHECK_SQL, (Bean)action);
        }
    }
}

