/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.api.macos.MacServiceManagement;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.macos.MacNative;
import org.jetbrains.annotations.NotNull;

public class ServiceManagement {
    private static final int ERROR_OK = 0;
    private static final int ERROR_UNKNOWN = -1;
    private static final int kSMErrorInternalFailure = 2;
    private static final int kSMErrorInvalidSignature = 3;
    private static final int kSMErrorAuthorizationFailure = 4;
    private static final int kSMErrorToolNotValid = 5;
    private static final int kSMErrorJobNotFound = 6;
    private static final int kSMErrorServiceUnavailable = 7;
    private static final int kSMErrorJobPlistNotFound = 8;
    private static final int kSMErrorJobMustBeEnabled = 9;
    private static final int kSMErrorInvalidPlist = 10;
    private static final int kSMErrorLaunchDeniedByUser = 11;
    private static final int kSMErrorAlreadyRegistered = 12;
    private static final int SMAppServiceStatusNotRegistered = 0;
    private static final int SMAppServiceStatusEnabled = 1;
    private static final int SMAppServiceStatusRequiresApproval = 2;
    private static final int SMAppServiceStatusNotFound = 3;

    private static native int registerMain0();

    private static native int unregisterMain0();

    private static native int getMainStatus0();

    private static native int register0(String var0, boolean var1);

    private static native int unregister0(String var0, boolean var1);

    private static native int getStatus0(String var0, boolean var1);

    private static native void openSystemSettingsLoginItems0();

    @NotNull
    public static MacServiceManagement.ServiceManagementResult registerMain() {
        if (MacNative.MACOS_13_PLUS) {
            return ServiceManagement.translateResult(ServiceManagement.registerMain0());
        }
        return MacServiceManagement.ServiceManagementResult.ERROR_UNSUPPORTED;
    }

    public static MacServiceManagement.AppServiceStatus getMainBundleStatus() {
        if (MacNative.MACOS_13_PLUS) {
            return ServiceManagement.translateStatus(ServiceManagement.getMainStatus0());
        }
        return null;
    }

    @NotNull
    public static MacServiceManagement.ServiceManagementResult unregisterMain() {
        if (MacNative.MACOS_13_PLUS) {
            return ServiceManagement.translateResult(ServiceManagement.unregisterMain0());
        }
        return MacServiceManagement.ServiceManagementResult.ERROR_UNSUPPORTED;
    }

    public static MacServiceManagement.ServiceManagementResult register(String plistName, boolean daemon) {
        if (MacNative.MACOS_13_PLUS) {
            return ServiceManagement.checkStatus(ServiceManagement.translateResult(ServiceManagement.register0(plistName, daemon)), plistName, daemon);
        }
        return MacServiceManagement.ServiceManagementResult.ERROR_UNSUPPORTED;
    }

    public static MacServiceManagement.ServiceManagementResult unregister(String plistName, boolean daemon) {
        if (MacNative.MACOS_13_PLUS) {
            return ServiceManagement.checkStatus(ServiceManagement.translateResult(ServiceManagement.unregister0(plistName, daemon)), plistName, daemon);
        }
        return MacServiceManagement.ServiceManagementResult.ERROR_UNSUPPORTED;
    }

    public static MacServiceManagement.AppServiceStatus getStatus(String plistName, boolean daemon) {
        if (MacNative.MACOS_13_PLUS) {
            return ServiceManagement.translateStatus(ServiceManagement.getStatus0(plistName, daemon));
        }
        return null;
    }

    private static MacServiceManagement.ServiceManagementResult checkStatus(MacServiceManagement.ServiceManagementResult result, String plistName, boolean daemon) {
        if (result == MacServiceManagement.ServiceManagementResult.ERROR_UNKNOWN && ServiceManagement.getStatus(plistName, daemon) == MacServiceManagement.AppServiceStatus.REQUIRES_APPROVAL) {
            return MacServiceManagement.ServiceManagementResult.ERROR_REQUIRES_APPROVAL;
        }
        return result;
    }

    public static boolean openSystemSettingsLoginItems() {
        if (MacNative.MACOS_13_PLUS) {
            ServiceManagement.openSystemSettingsLoginItems0();
            return true;
        }
        return false;
    }

    private static MacServiceManagement.ServiceManagementResult translateResult(int code) {
        switch (code) {
            case 0: {
                return MacServiceManagement.ServiceManagementResult.OK;
            }
            case -1: {
                return MacServiceManagement.ServiceManagementResult.ERROR_UNKNOWN;
            }
            case 2: {
                return MacServiceManagement.ServiceManagementResult.ERROR_INTERNAL_FAILURE;
            }
            case 3: {
                return MacServiceManagement.ServiceManagementResult.ERROR_INVALID_SIGNATURE;
            }
            case 4: {
                return MacServiceManagement.ServiceManagementResult.ERROR_AUTHORIZATION_FAILURE;
            }
            case 5: {
                return MacServiceManagement.ServiceManagementResult.ERROR_TOOL_NOT_VALID;
            }
            case 6: {
                return MacServiceManagement.ServiceManagementResult.ERROR_JOB_NOT_FOUND;
            }
            case 7: {
                return MacServiceManagement.ServiceManagementResult.ERROR_SERVICE_UNAVAILABLE;
            }
            case 8: {
                return MacServiceManagement.ServiceManagementResult.ERROR_JOB_PLIST_NOT_FOUND;
            }
            case 9: {
                return MacServiceManagement.ServiceManagementResult.ERROR_JOB_MUST_BE_ENABLED;
            }
            case 10: {
                return MacServiceManagement.ServiceManagementResult.ERROR_INVALID_PLIST;
            }
            case 11: {
                return MacServiceManagement.ServiceManagementResult.ERROR_LAUNCH_DENIED_BY_USER;
            }
            case 12: {
                return MacServiceManagement.ServiceManagementResult.ERROR_ALREADY_REGISTERED;
            }
        }
        Logger.getInstance().info(null, "Service management error code " + code);
        return MacServiceManagement.ServiceManagementResult.ERROR_UNKNOWN;
    }

    private static MacServiceManagement.AppServiceStatus translateStatus(int code) {
        switch (code) {
            case -1: {
                return null;
            }
            case 0: {
                return MacServiceManagement.AppServiceStatus.NOT_REGISTERED;
            }
            case 1: {
                return MacServiceManagement.AppServiceStatus.ENABLED;
            }
            case 2: {
                return MacServiceManagement.AppServiceStatus.REQUIRES_APPROVAL;
            }
            case 3: {
                return MacServiceManagement.AppServiceStatus.NOT_FOUND;
            }
        }
        Logger.getInstance().error(null, "Unknown service management status code " + code);
        return null;
    }

    static {
        MacNative.init1012();
    }
}

