/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.services;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.api.windows.WinUser;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.services.ServiceAccount;
import com.install4j.runtime.beans.actions.services.WindowsPriority;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.AutoUninstallNotPerformedException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.CompilerVariableHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.unix.ServiceFile;
import com.install4j.runtime.installer.platform.win32.Win32Services;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;
import com.install4j.runtime.util.DirectoryUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class InstallServiceAction
extends SystemAutoUninstallInstallAction
implements PropertyLoggingInterceptor {
    public static final String SYSTEMCTL_PATH = "/usr/bin/systemctl";
    public static final String SYSTEMD_CONFIG_PATH = "/etc/systemd/system";
    public static final String INITD_PATH = "/etc/init.d";
    public static final String SYSTEMCTL_NO_ASK_PASSWORD = "--no-ask-password";
    public static final String SYSTEMCTL_USER = "--user";
    private static final String NAME_RESTART_MILLIS = "serviceRestartMillis";
    private static final String NAME_MAX_RESTARTS = "serviceMaxRestarts";
    private static final String NAME_RESET_SECONDS = "serviceResetSeconds";
    private String launcherId = "";
    private File executable;
    private String serviceName;
    private boolean autoStart = true;
    private String description = "";
    private String windowsDependencies = "";
    private String macosIdentifier = "";
    private String windowsArguments = "";
    private String windowsDisplayName = "";
    private boolean restartOnFailure;
    private int restartMillis = 1000;
    private int maxRestarts = 0;
    private int resetSeconds = 0;
    private boolean interactive;
    private boolean delayedAutoStart;
    private WindowsPriority windowsPriority = WindowsPriority.NORMAL_PRIORITY_CLASS;
    private String additionalSystemdEntries = "";
    private ServiceAccount serviceAccount = ServiceAccount.LOCAL_SYSTEM;
    private String accountNameOrSid = "";
    private String password = "";
    private boolean keepCurrentAccount = false;
    private static final String PROP_SERVICE_PATH = "servicePath";
    private static final String PROP_SERVICE_NAME = "serviceName";
    private static final String PROP_STARTUP_TYPE = "startupType";
    private static final String PROP_IDENTIFIER = "identifier";
    private static final String PROP_CONFIG_FILE = "configFile";
    private static final String PROP_CONFIG_TARGET = "configTarget";
    private static final String STARTUP_ITEMS_FILE_NAME = "/Library/StartupItems";
    public static final String LAUNCH_DAEMONS_FILE_NAME = "/Library/LaunchDaemons";
    private static final String REGKEY_PRIORITY = "SOFTWARE\\ej-technologies\\exe4j\\priority";
    private static List<Info> installedServices = new ArrayList<Info>();

    public static List<Info> getInstalledServices() {
        return installedServices;
    }

    private String getUsedPassword() {
        if (this.getServiceAccount() == ServiceAccount.OTHER) {
            return this.getPassword();
        }
        return "";
    }

    private String getAccountNameOrSidForPrivileges() {
        if (this.getServiceAccount() == ServiceAccount.OTHER) {
            return this.getAccountNameOrSid();
        }
        return null;
    }

    private String getUsedAccountName() {
        if (this.getServiceAccount() == ServiceAccount.OTHER) {
            String accountName = WinUser.getAccountName(this.getAccountNameOrSid());
            if (accountName != null) {
                return accountName;
            }
            return this.getAccountNameOrSid();
        }
        return this.getServiceAccount().getAccountName();
    }

    public String getWindowsDisplayName() {
        return InstallServiceAction.replaceVariables(InstallServiceAction.replaceVariables(this.windowsDisplayName));
    }

    public void setWindowsDisplayName(String windowsDisplayName) {
        this.windowsDisplayName = windowsDisplayName;
    }

    public String getAdditionalSystemdEntries() {
        return InstallServiceAction.replaceVariables(InstallServiceAction.replaceVariables(this.additionalSystemdEntries));
    }

    public void setAdditionalSystemdEntries(String additionalSystemdEntries) {
        this.additionalSystemdEntries = additionalSystemdEntries;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        File usedExecutable;
        String usedName;
        ProgressInterface progressInterface = context.getProgressInterface();
        progressInterface.setDetailMessage("");
        String additionalPlistContent = "";
        LauncherSetup launcherSetup = null;
        if (this.getLauncherId() == null) {
            usedName = this.getServiceName();
            usedExecutable = context.getDestinationFile(this.getExecutable());
        } else {
            launcherSetup = context.getLauncherById(this.getLauncherId());
            if (launcherSetup == null) {
                Logger.getInstance().log(this, "The launcher with ID " + this.getLauncherId() + " cannot be found", false);
                return false;
            }
            usedExecutable = context.getDestinationFile(launcherSetup.getRelativeFileName());
            usedName = launcherSetup.getName();
            additionalPlistContent = InstallServiceAction.replaceVariables(((ContextImpl.LauncherSetupImpl)launcherSetup).getLauncherConfig().getPlistContent());
        }
        if (!usedExecutable.exists()) {
            Logger.getInstance().log(this, "The executable " + usedExecutable + " does not exist", false);
            return false;
        }
        String usedIdentifier = null;
        String binaryPath = usedExecutable.getAbsolutePath();
        try {
            if (InstallerUtil.isWindows()) {
                if (binaryPath.indexOf(32) > -1) {
                    binaryPath = "\"" + binaryPath + "\"";
                }
                if (this.getWindowsArguments() != null && !this.getWindowsArguments().trim().isEmpty()) {
                    binaryPath = binaryPath + " " + this.getWindowsArguments().trim();
                }
                String usedDisplayName = usedName;
                if (this.getWindowsDisplayName() != null && !this.getWindowsDisplayName().trim().isEmpty()) {
                    usedDisplayName = this.getWindowsDisplayName().trim();
                }
                int restartMillis = this.getRestartMillis(context, usedName);
                int maxRestarts = this.getMaxRestarts(context, usedName);
                int resetSeconds = this.getResetSeconds(context, usedName);
                Serializable ret = context.runElevated(new InstallWindowsRemoteCallable(usedName, usedDisplayName, binaryPath, this.isInteractive(), this.isDelayedAutoStart(), this.isAutoStart(), this.isKeepCurrentAccount(), this.getWindowsDependencies(), this.getUsedAccountName(), this.getUsedPassword(), this.getAccountNameOrSidForPrivileges(), this.getDescription(), this.getWindowsPriority().getValue(), this.isRestartOnFailure(), restartMillis, maxRestarts, resetSeconds), true);
                if (ret instanceof Win32Services.ServiceException) {
                    throw (Win32Services.ServiceException)ret;
                }
            } else if (InstallerUtil.isMacOS()) {
                Serializable ret;
                usedIdentifier = this.getMacosIdentifier();
                if (usedIdentifier == null || usedIdentifier.trim().isEmpty()) {
                    usedIdentifier = "com.install4j." + context.getApplicationId() + "." + usedExecutable.getName();
                    Logger.getInstance().info(this, "Using fallback identifier: " + usedIdentifier);
                }
                if ((ret = context.runElevated(new InstallMacosRemoteCallable(usedExecutable, usedName, usedIdentifier, this.isAutoStart(), additionalPlistContent), false)) instanceof IOException) {
                    throw (IOException)ret;
                }
            } else if (!this.installUnix(context, usedExecutable, usedName, launcherSetup)) {
                return false;
            }
        }
        catch (Win32Services.ServiceException e) {
            if (e.getErrorCode() == 1057) {
                Logger.getInstance().error(this, "Invalid service account.");
            } else if (e.getErrorCode() == 5) {
                Logger.getInstance().error(this, "Access denied. Need to be elevated administrator.");
            } else if (e.getErrorCode() == 1060) {
                Logger.getInstance().error(this, "Service does not exist.");
            } else if (e.getErrorCode() == 1069) {
                Logger.getInstance().error(this, "Logon to service account failed. Password is wrong or user does not have log on as service privilege.");
            } else {
                Logger.getInstance().log(e);
            }
            progressInterface.showFailure(Messages.format(Messages.getString(".ErrorInstallService"), usedName) + (e.getMessage() != null ? "\n\n" + e.getMessage() : ""));
            return false;
        }
        catch (Exception e) {
            progressInterface.showFailure(Messages.format(Messages.getString(".ErrorInstallService"), usedName) + (e.getMessage() != null ? "\n\n" + e.getMessage() : ""));
            Logger.getInstance().log(e);
            return false;
        }
        Properties persistentProperties = this.getPersistentProperties();
        persistentProperties.setProperty(PROP_SERVICE_PATH, binaryPath);
        persistentProperties.setProperty(PROP_SERVICE_NAME, usedName);
        persistentProperties.setProperty(PROP_STARTUP_TYPE, this.isAutoStart() ? "auto" : "manual");
        if (usedIdentifier != null) {
            persistentProperties.setProperty(PROP_IDENTIFIER, usedIdentifier);
        }
        installedServices.add(new Info(usedExecutable.getAbsolutePath(), usedName, usedIdentifier));
        return true;
    }

    @Override
    public void rollback(InstallerContext context) {
        this.doUninstallation(context);
    }

    @Override
    public boolean uninstall(UninstallerContext context) {
        if (Boolean.getBoolean("install4j.dontUninstallServices")) {
            Logger.getInstance().info(this, "Keep services");
            throw new AutoUninstallNotPerformedException();
        }
        this.doUninstallation(context);
        return true;
    }

    private void doUninstallation(Context context) {
        Properties persistentProperties = this.getPersistentProperties();
        String serviceName = persistentProperties.getProperty(PROP_SERVICE_NAME);
        Logger.getInstance().info(this, "service name " + serviceName);
        if (serviceName == null) {
            return;
        }
        try {
            if (InstallerUtil.isWindows()) {
                Serializable ret = context.runElevated(new UninstallWindowsRemoteCallable(serviceName, persistentProperties.getProperty(PROP_SERVICE_PATH)), true);
                if (ret instanceof Win32Services.ServiceException) {
                    throw (Win32Services.ServiceException)ret;
                }
            } else if (InstallerUtil.isMacOS()) {
                String startupType = persistentProperties.getProperty(PROP_STARTUP_TYPE);
                String identifier = persistentProperties.getProperty(PROP_IDENTIFIER);
                context.runElevated(new UninstallMacosRemoteCallable(serviceName, identifier, startupType), true);
            } else {
                UnixFileSystem.FileInformation fileInformation;
                String fileName = persistentProperties.getProperty(PROP_SERVICE_PATH);
                Logger.getInstance().info(this, "service path " + fileName);
                if (fileName == null) {
                    return;
                }
                File serviceExecutable = new File(fileName);
                if (!serviceExecutable.exists()) {
                    Logger.getInstance().info(this, "service executable does not exist");
                    return;
                }
                File initdLink = new File(INITD_PATH, serviceExecutable.getName());
                if (initdLink.exists() && (fileInformation = UnixFileSystem.getFileInformation(initdLink)) != null && fileInformation.isLink() && Objects.equals(fileInformation.getLinkTarget(), serviceExecutable.getAbsolutePath()) && initdLink.delete()) {
                    InstallServiceAction.reloadSystemCtl(false);
                }
                String configFilePath = persistentProperties.getProperty(PROP_CONFIG_FILE);
                Logger.getInstance().info(this, "config file path " + configFilePath);
                if (configFilePath != null) {
                    File configFile = new File(configFilePath);
                    File configEtcFile = new File(SYSTEMD_CONFIG_PATH, configFile.getName());
                    if (FileUtil.getCanonicalFile(configFile).equals(FileUtil.getCanonicalFile(configEtcFile))) {
                        String configTarget = persistentProperties.getProperty(PROP_CONFIG_TARGET);
                        String content = null;
                        if (configTarget != null) {
                            try {
                                content = FileUtil.readTextFile(configFile, "UTF-8");
                            }
                            catch (Exception e) {
                                Logger.getInstance().log(e);
                            }
                        }
                        if (content == null || content.contains(configTarget)) {
                            InstallServiceAction.doUninstallSystemd(false, serviceExecutable.getName(), configEtcFile);
                        } else {
                            Logger.getInstance().info(this, "config file does not contain target " + configTarget);
                        }
                    } else {
                        UnixFileSystem.FileInformation fileInformation2 = UnixFileSystem.getFileInformation(configEtcFile);
                        if (fileInformation2 != null && fileInformation2.isLink() && Objects.equals(fileInformation2.getLinkTarget(), configFile.getAbsolutePath())) {
                            InstallServiceAction.doUninstallSystemd(false, serviceExecutable.getName(), configEtcFile);
                        }
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            Logger.getInstance().log(e);
            ProgressInterface progressInterface = context.getProgressInterface();
            progressInterface.showFailure(Messages.format(Messages.getString(".ErrorUninstallService"), serviceName));
            return;
        }
    }

    public static void doUninstallSystemd(boolean user, String serviceName, File configEtcFile) {
        InstallServiceAction.callSystemCtl(user, serviceName, "stop");
        InstallServiceAction.callSystemCtl(user, serviceName, "disable");
        if (configEtcFile.delete()) {
            InstallServiceAction.reloadSystemCtl(user);
        }
    }

    private static boolean useSystemd(InstallerContext context, LauncherSetup launcherSetup) {
        return CompilerVariableHelper.getCompilerExtensionVariable((Context)context, "useSystemd", true) && (launcherSetup == null || CompilerVariableHelper.getCompilerExtensionVariable((Context)context, "useSystemd." + launcherSetup.getId(), true));
    }

    public static boolean isSystemdFilesAvailable() {
        return new File(SYSTEMCTL_PATH).isFile() && new File(SYSTEMD_CONFIG_PATH).isDirectory() && new File("/run/systemd/system").isDirectory();
    }

    private boolean installUnix(InstallerContext context, File serviceExecutable, String name, LauncherSetup launcherSetup) throws IOException {
        File initdLinkFile = new File(INITD_PATH, serviceExecutable.getName());
        String target = serviceExecutable.getAbsolutePath();
        if (InstallServiceAction.useSystemd(context, launcherSetup) && InstallServiceAction.isSystemdFilesAvailable()) {
            int systemdVersion;
            UnixFileSystem.FileInformation fileInformation;
            if (initdLinkFile.isFile() && (fileInformation = UnixFileSystem.getFileInformation(initdLinkFile)) != null && fileInformation.isLink() && FileUtil.getCanonicalFile(new File(fileInformation.getLinkTarget())).equals(FileUtil.getCanonicalFile(serviceExecutable))) {
                initdLinkFile.delete();
            }
            ServiceFile serviceFile = ServiceFile.createForServiceLauncher(target, name, (systemdVersion = ServiceHandler.getSystemdVersion()) >= 240);
            serviceFile.addContent(MenuHelper.getAdditionalEntries(launcherSetup));
            serviceFile.addContent(this.getAdditionalSystemdEntries());
            File configFile = context.getDestinationFile(".install4j/" + serviceExecutable.getName() + ".service");
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8));){
                serviceFile.print(pw);
            }
            FileInstaller.getInstance().registerUninstallFile(configFile);
            File configEtcFile = new File(SYSTEMD_CONFIG_PATH, configFile.getName());
            configEtcFile.delete();
            FileUtil.copyFile(configFile, configEtcFile);
            configFile = configEtcFile;
            this.getPersistentProperties().setProperty(PROP_CONFIG_FILE, configFile.getAbsolutePath());
            this.getPersistentProperties().setProperty(PROP_CONFIG_TARGET, target);
            this.reloadAndStartUnix(configEtcFile);
        } else if (UnixFileSystem.createLink(target, initdLinkFile)) {
            this.reloadAndStartUnix(serviceExecutable);
        } else {
            return false;
        }
        return true;
    }

    private void reloadAndStartUnix(File serviceFile) {
        if (InstallServiceAction.reloadSystemCtl(false) && this.isAutoStart()) {
            InstallServiceAction.callSystemCtl(false, serviceFile.getName(), "enable");
        }
    }

    public static void callSystemCtl(boolean user, String serviceName, String command) {
        Integer returnValue = LaunchHelper.launchApplication(new LaunchDescriptor(new File(SYSTEMCTL_PATH)).arguments(user ? SYSTEMCTL_USER : SYSTEMCTL_NO_ASK_PASSWORD, command, serviceName).wait(true));
        Logger.getInstance().info(null, "systemctl " + command + " return: " + returnValue);
    }

    public static boolean reloadSystemCtl(boolean user) {
        File systemctlFile = new File(SYSTEMCTL_PATH);
        if (systemctlFile.isFile()) {
            Integer returnValue = LaunchHelper.launchApplication(new LaunchDescriptor(systemctlFile).arguments(user ? SYSTEMCTL_USER : SYSTEMCTL_NO_ASK_PASSWORD, "daemon-reload").wait(true));
            Logger.getInstance().info(null, "systemctl daemon-reload return: " + returnValue);
            return returnValue != null && returnValue == 0;
        }
        return false;
    }

    public String getServiceName() {
        return InstallServiceAction.replaceVariables(InstallServiceAction.replaceVariables(this.serviceName));
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isAutoStart() {
        return this.replaceWithTextOverride("autoStart", this.autoStart);
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public File getExecutable() {
        return this.replaceWithTextOverride("executable", InstallServiceAction.replaceVariables(this.executable), File.class);
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public String getWindowsArguments() {
        return InstallServiceAction.replaceVariables(InstallServiceAction.replaceVariables(this.windowsArguments));
    }

    public void setWindowsArguments(String windowsArguments) {
        this.windowsArguments = windowsArguments;
    }

    public String getLauncherId() {
        return InstallServiceAction.replaceVariables(this.launcherId);
    }

    public void setLauncherId(String launcherId) {
        this.launcherId = launcherId;
    }

    public String getDescription() {
        return InstallServiceAction.replaceVariables(InstallServiceAction.replaceVariables(this.description));
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getWindowsDependencies() {
        return InstallServiceAction.replaceVariables(InstallServiceAction.replaceVariables(this.windowsDependencies));
    }

    public void setWindowsDependencies(String windowsDependencies) {
        this.windowsDependencies = windowsDependencies;
    }

    public String getMacosIdentifier() {
        return InstallServiceAction.replaceVariables(InstallServiceAction.replaceVariables(this.macosIdentifier));
    }

    public void setMacosIdentifier(String macosIdentifier) {
        this.macosIdentifier = macosIdentifier;
    }

    public boolean isRestartOnFailure() {
        return this.replaceWithTextOverride("restartOnFailure", this.restartOnFailure);
    }

    public void setRestartOnFailure(boolean restartOnFailure) {
        this.restartOnFailure = restartOnFailure;
    }

    public int getRestartMillis() {
        return this.replaceWithTextOverride("restartMillis", this.restartMillis);
    }

    public void setRestartMillis(int restartMillis) {
        this.restartMillis = restartMillis;
    }

    public int getMaxRestarts() {
        return this.replaceWithTextOverride("maxRestarts", this.maxRestarts);
    }

    public void setMaxRestarts(int maxRestarts) {
        this.maxRestarts = maxRestarts;
    }

    public int getResetSeconds() {
        return this.replaceWithTextOverride("resetSeconds", this.resetSeconds);
    }

    public void setResetSeconds(int resetSeconds) {
        this.resetSeconds = resetSeconds;
    }

    public boolean isInteractive() {
        return this.replaceWithTextOverride("interactive", this.interactive);
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isDelayedAutoStart() {
        return this.replaceWithTextOverride("delayedAutoStart", this.delayedAutoStart);
    }

    public void setDelayedAutoStart(boolean delayedAutoStart) {
        this.delayedAutoStart = delayedAutoStart;
    }

    public String getAccountNameOrSid() {
        return InstallServiceAction.replaceVariables(InstallServiceAction.replaceVariables(this.accountNameOrSid));
    }

    public void setAccountNameOrSid(String accountNameOrSid) {
        this.accountNameOrSid = accountNameOrSid;
    }

    public String getPassword() {
        return InstallServiceAction.replaceVariables(InstallServiceAction.replaceVariables(this.password));
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ServiceAccount getServiceAccount() {
        return this.replaceWithTextOverride("serviceAccount", this.serviceAccount, ServiceAccount.class);
    }

    public void setServiceAccount(ServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public boolean isKeepCurrentAccount() {
        return this.replaceWithTextOverride("keepCurrentAccount", this.keepCurrentAccount);
    }

    public void setKeepCurrentAccount(boolean keepCurrentAccount) {
        this.keepCurrentAccount = keepCurrentAccount;
    }

    public WindowsPriority getWindowsPriority() {
        return this.replaceWithTextOverride("windowsPriority", this.windowsPriority, WindowsPriority.class);
    }

    public void setWindowsPriority(WindowsPriority windowsPriority) {
        this.windowsPriority = windowsPriority;
    }

    @Override
    public Object getLogValueForProperty(String propertyName, Object propertyValue) {
        if (Objects.equals(propertyName, "password") && !Boolean.getBoolean("install4j.logServicePassword")) {
            return "[logging of password is disabled]";
        }
        return propertyValue;
    }

    private int getRestartMillis(Context context, String serviceName) {
        return CompilerVariableHelper.getCompilerExtensionVariable(context, "serviceRestartMillis." + serviceName, CompilerVariableHelper.getCompilerExtensionVariable(context, NAME_RESTART_MILLIS, this.getRestartMillis()));
    }

    private int getMaxRestarts(Context context, String serviceName) {
        return CompilerVariableHelper.getCompilerExtensionVariable(context, "serviceMaxRestarts." + serviceName, CompilerVariableHelper.getCompilerExtensionVariable(context, NAME_MAX_RESTARTS, this.getMaxRestarts()));
    }

    private int getResetSeconds(Context context, String serviceName) {
        return CompilerVariableHelper.getCompilerExtensionVariable(context, "serviceResetSeconds." + serviceName, CompilerVariableHelper.getCompilerExtensionVariable(context, NAME_RESET_SECONDS, this.getResetSeconds()));
    }

    public static class Info {
        private final String executable;
        private final String serviceName;
        private final String macosIdentifier;

        public Info(String executable, String serviceName, String macosIdentifier) {
            this.executable = executable;
            this.serviceName = serviceName;
            this.macosIdentifier = macosIdentifier;
        }

        public String getExecutable() {
            return this.executable;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getMacosIdentifier() {
            return this.macosIdentifier;
        }
    }

    private static class InstallMacosRemoteCallable
    extends AbstractRemoteCallable {
        File execFile;
        String name;
        String identifier;
        private boolean autoStart;
        private final String additionalPlistContent;

        private InstallMacosRemoteCallable(File execFile, String name, String identifier, boolean autoStart, String additionalPlistContent) {
            this.execFile = execFile;
            this.name = name;
            this.identifier = identifier;
            this.autoStart = autoStart;
            this.additionalPlistContent = additionalPlistContent;
        }

        @Override
        public Serializable execute() {
            if (!this.execFile.exists()) {
                return null;
            }
            try {
                File startupItemDir = new File(InstallServiceAction.STARTUP_ITEMS_FILE_NAME, this.name);
                DirectoryUtil.deleteDirectory(startupItemDir);
                this.createLaunchDaemon();
            }
            catch (IOException e) {
                return e;
            }
            return null;
        }

        private void createLaunchDaemon() throws IOException {
            File plistFile = new File(InstallServiceAction.LAUNCH_DAEMONS_FILE_NAME, this.identifier + ".plist");
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(plistFile), StandardCharsets.UTF_8));){
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict>\n    <key>Label</key>\n    <string>" + PlistHelper.quoteCharacters(this.identifier) + "</string>\n    <key>ProgramArguments</key>\n    <array>\n        <string>" + PlistHelper.quoteCharacters(this.execFile.getCanonicalPath()) + "</string>\n         <string>start-launchd</string>\n    </array>\n    <key>KeepAlive</key>\n    <false/>\n    <key>RunAtLoad</key>\n    <" + this.autoStart + "/>\n" + this.additionalPlistContent + "</dict>\n</plist>");
            }
            UnixFileSystem.setMode("644", plistFile);
        }
    }

    private static class UninstallMacosRemoteCallable
    extends AbstractRemoteCallable {
        String serviceName;
        private String identifier;
        private String startupType;

        private UninstallMacosRemoteCallable(String serviceName, String identifier, String startupType) {
            this.serviceName = serviceName;
            this.identifier = identifier;
            this.startupType = startupType;
        }

        @Override
        public Serializable execute() {
            File plistFile;
            if (this.serviceName != null && !this.serviceName.trim().isEmpty() && Objects.equals("auto", this.startupType)) {
                File dir = new File(InstallServiceAction.STARTUP_ITEMS_FILE_NAME, this.serviceName);
                DirectoryUtil.deleteDirectory(dir);
            }
            if (this.identifier != null && (plistFile = new File(InstallServiceAction.LAUNCH_DAEMONS_FILE_NAME, this.identifier + ".plist")).exists()) {
                LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File("/bin/launchctl")).wait(true).executionContext(ExecutionContext.MAXIMUM).suidRoot(true);
                boolean success = LaunchHelper.launchApplicationAndCheck(launchDescriptor.arguments("bootout", "system", plistFile.getAbsolutePath()));
                Logger.getInstance().info(this, "Unload: " + success);
                if (!plistFile.delete()) {
                    plistFile.deleteOnExit();
                }
            }
            return null;
        }
    }

    private static class InstallWindowsRemoteCallable
    extends AbstractRemoteCallable {
        String usedName;
        String displayName;
        String binaryPath;
        private boolean interactive;
        private final boolean delayedAutoStart;
        private boolean autoStart;
        private boolean keepCurrentAccount;
        private String dependencies;
        private String accountName;
        private String password;
        private String accountNameOrSidForPrivileges;
        private String description;
        private int priority;
        private boolean restartOnFailure;
        private final int restartMillis;
        private final int maxRestarts;
        private final int resetSeconds;

        private InstallWindowsRemoteCallable(String usedName, String displayName, String binaryPath, boolean interactive, boolean delayedAutoStart, boolean autoStart, boolean keepCurrentAccount, String dependencies, String accountName, String password, String accountNameOrSidForPrivileges, String description, int priority, boolean restartOnFailure, int restartMillis, int maxRestarts, int resetSeconds) {
            this.usedName = usedName;
            this.displayName = displayName;
            this.binaryPath = binaryPath;
            this.interactive = interactive;
            this.delayedAutoStart = delayedAutoStart;
            this.autoStart = autoStart;
            this.keepCurrentAccount = keepCurrentAccount;
            this.dependencies = dependencies;
            this.accountName = accountName;
            this.password = password;
            this.accountNameOrSidForPrivileges = accountNameOrSidForPrivileges;
            this.description = description;
            this.priority = priority;
            this.restartOnFailure = restartOnFailure;
            this.restartMillis = restartMillis;
            this.maxRestarts = maxRestarts;
            this.resetSeconds = resetSeconds;
        }

        @Override
        public Serializable execute() {
            boolean existing = false;
            try {
                try {
                    Win32Services.installService(this.usedName, this.displayName, this.binaryPath);
                }
                catch (Win32Services.ServiceException e) {
                    if (e.getErrorCode() == 1073) {
                        existing = true;
                    }
                    throw e;
                }
                if (this.keepCurrentAccount && existing) {
                    this.accountName = null;
                    this.password = null;
                    this.accountNameOrSidForPrivileges = null;
                }
                WinRegistry.createKey(RegistryRoot.HKEY_LOCAL_MACHINE, InstallServiceAction.REGKEY_PRIORITY);
                WinRegistry.setValue(RegistryRoot.HKEY_LOCAL_MACHINE, InstallServiceAction.REGKEY_PRIORITY, this.usedName, this.priority);
                Win32Services.changeServiceConfig(this.usedName, this.displayName, this.binaryPath, this.interactive, this.autoStart ? 2 : 3, this.dependencies, this.accountName, this.password, this.description);
                Win32Services.setRestartServiceConfig(this.usedName, this.restartOnFailure, this.restartMillis, this.maxRestarts, this.resetSeconds);
                if (InstallerUtil.isAtLeastWindowsVista()) {
                    Win32Services.setDelayedAutoStart(this.usedName, this.delayedAutoStart);
                }
                if (this.accountNameOrSidForPrivileges != null) {
                    Win32UserInfo.setLsaAccountRight(this.accountNameOrSidForPrivileges, "SeServiceLogonRight", true);
                }
            }
            catch (Win32Services.ServiceException e) {
                return e;
            }
            return null;
        }
    }

    private static class UninstallWindowsRemoteCallable
    extends AbstractRemoteCallable {
        String serviceName;
        private String binaryPath;

        private UninstallWindowsRemoteCallable(String serviceName, String binaryPath) {
            this.serviceName = serviceName;
            this.binaryPath = binaryPath;
        }

        @Override
        public Serializable execute() {
            block3: {
                try {
                    String registeredBinary = Win32Services.getServiceBinary(this.serviceName);
                    if (this.binaryPath == null || this.binaryPath.equals(registeredBinary)) {
                        Win32Services.uninstallService(this.serviceName);
                    }
                }
                catch (Win32Services.ServiceException e) {
                    if (e.getErrorCode() == 1060) break block3;
                    return e;
                }
            }
            return null;
        }
    }
}

