/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.Util;
import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.AutoUninstallHandler;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.AutoUninstallNotPerformedException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.ContextIntProxy;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.content.JreInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.fileinst.UninstallLogNotFoundException;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class UninstallFilesAction
extends SystemInstallOrUninstallAction {
    public static final String PROPNAME_PACKAGE_UNINSTALL = "install4j.packageUninstall";

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        File responseFile;
        boolean uninstallForUpgrade;
        if (!(context instanceof UninstallerContext) && !Boolean.getBoolean(PROPNAME_PACKAGE_UNINSTALL)) {
            Logger.getInstance().error(this, "UninstallFilesAction can only be used for uninstaller or for package pre-uninstallation.");
            return false;
        }
        ServiceHandler.stopServices(context, false);
        String uninstallMessage = Messages.format(context.getMessage(".StatusUninstalling"), InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
        ProgressInterface progressInterface = context.getProgressInterface();
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(uninstallMessage);
        if (!RunningProcessChecker.checkDefaultRunningLauncher()) {
            throw new UserCanceledException();
        }
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(uninstallMessage);
        if (!UninstallFilesAction.executeAutoUninstallActions()) {
            return false;
        }
        boolean bl = uninstallForUpgrade = context instanceof UninstallerContext && ((UninstallerContext)context).isUninstallForUpgrade();
        if (uninstallForUpgrade && (responseFile = context.getDestinationFile(".install4j" + File.separator + "response.varfile")).isFile()) {
            FileInstaller.getInstance().addRetainedFile(responseFile);
        }
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(uninstallMessage);
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        UninstallFilesAction.preloadClasses();
        InstallRegistry.unregisterApplication(config.getApplicationId(), context.getInstallationDirectory());
        JreInstaller.getInstance().prepareUninstall(context, uninstallForUpgrade);
        FileInstaller fileInstaller = FileInstaller.getInstance();
        try {
            for (String fileName : config.getUninstallDeleteEntries()) {
                fileInstaller.deleteFile(context.getDestinationFile(UninstallFilesAction.replaceVariables(fileName)));
            }
            fileInstaller.uninstall(uninstallForUpgrade, context.getInstallationDirectory());
        }
        catch (UninstallLogNotFoundException e) {
            UninstallFilesAction.handleLogNotFound(e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof UninstallLogNotFoundException) {
                UninstallFilesAction.handleLogNotFound((UninstallLogNotFoundException)e.getCause());
            }
            throw e;
        }
        catch (IOException e) {
            context.handleCriticalException(e);
        }
        if (!InstallerUtil.isWindows() && !InstallerUtil.isMacOS()) {
            try {
                Runtime.getRuntime().exec("kbuildsycoca");
                MenuHelper.updateDesktopDatabase();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (InstallerUtil.isMacOS()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static void handleLogNotFound(UninstallLogNotFoundException e) {
        Logger.getInstance().log(e);
        Util.showErrorMessage(Messages.getString(".UninstallerFatalError"));
        ContextInt contextInt = ContextImpl.getSingleContextInt();
        if (contextInt != null) {
            contextInt.immediateExit(1);
        } else {
            InstallerUtil.exit(1);
        }
    }

    private static void preloadClasses() {
        try {
            Install4jClassLoader.getInstance().loadClass("com.install4j.script.I4jScript_Internal_0");
        }
        catch (Throwable e) {
            Logger.getInstance().log(e);
        }
        try {
            for (int i = 1; i < 20; ++i) {
                Install4jClassLoader.getInstance().loadClass("com.install4j.script.I4jScript_Internal_0_" + i);
            }
        }
        catch (Throwable i) {
            // empty catch block
        }
        try {
            new SecureRandom();
        }
        catch (Throwable e) {
            Logger.getInstance().log(e);
        }
    }

    public static void autoUninstallBeforeProcessCheck(Context context) {
        HelperCommunication.getInstance().runAction(ExecutionContext.MAXIMUM, maximumContext -> {
            try {
                AutoUninstallProcessor processor = new AutoUninstallProcessor(){

                    @Override
                    public boolean handle(AutoUninstallAction autoUninstallAction) throws UserCanceledException {
                        if (autoUninstallAction instanceof SystemAutoUninstallInstallAction) {
                            ((SystemAutoUninstallInstallAction)autoUninstallAction).runBeforeProcessCheck(maximumContext);
                        }
                        return false;
                    }

                    @Override
                    public boolean shouldWriteRetained(List<AutoUninstallAction> retainedActions) {
                        return false;
                    }
                };
                UninstallFilesAction.iterateAutoUninstallActions(context, processor);
            }
            catch (Exception e) {
                Logger.getInstance().log(e);
            }
        });
    }

    private static boolean executeAutoUninstallActions() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.MAXIMUM, context -> {
            try {
                final UninstallerContext uninstallerContext = context instanceof UninstallerContext ? (UninstallerContext)context : new UninstallerContextSham((ContextInt)context);
                AutoUninstallProcessor processor = new AutoUninstallProcessor(){

                    @Override
                    public boolean handle(AutoUninstallAction autoUninstallAction) throws UserCanceledException {
                        return UninstallFilesAction.executeAutoUninstallAction(uninstallerContext, autoUninstallAction);
                    }

                    @Override
                    public boolean shouldWriteRetained(List<AutoUninstallAction> retainedActions) {
                        return uninstallerContext.isUninstallForUpgrade() && !retainedActions.isEmpty();
                    }
                };
                if (!UninstallFilesAction.iterateAutoUninstallActions(uninstallerContext, processor)) {
                    return false;
                }
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
            return true;
        });
    }

    private static boolean executeAutoUninstallAction(UninstallerContext context, AutoUninstallAction autoUninstallAction) throws UserCanceledException {
        Logger.getInstance().info(autoUninstallAction, "executing auto uninstall action " + autoUninstallAction.getClass().getName());
        try {
            if (!autoUninstallAction.uninstall(context)) {
                Logger.getInstance().error(autoUninstallAction, "auto-uninstall action failed");
            }
        }
        catch (AutoUninstallNotPerformedException e) {
            return false;
        }
        catch (UserCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.getInstance().error(autoUninstallAction, "auto-uninstall action exception:");
            Logger.getInstance().log(t);
        }
        return true;
    }

    public static boolean iterateAutoUninstallActions(Context context, AutoUninstallProcessor processor) throws IOException {
        File runtimeDirectory = context.getDestinationFile(".install4j");
        List<Integer> autoUninstallFileNumbers = AutoUninstallHandler.getAutoUninstallFileNumbers(runtimeDirectory);
        Collections.reverse(autoUninstallFileNumbers);
        HashSet<AutoUninstallIdentifier> processedActions = new HashSet<AutoUninstallIdentifier>();
        for (int number : autoUninstallFileNumbers) {
            File autoUninstallFile = new File(runtimeDirectory, "autoUninstall." + number);
            List<AutoUninstallAction> autoUninstallActions = AutoUninstallHandler.getAutoUninstallActionsFromFile(autoUninstallFile);
            ArrayList<AutoUninstallAction> retainedActions = new ArrayList<AutoUninstallAction>();
            for (AutoUninstallAction autoUninstallAction : autoUninstallActions) {
                try {
                    if (!processedActions.add(new AutoUninstallIdentifier(autoUninstallAction.getClass(), autoUninstallAction.getPersistentProperties())) || processor.handle(autoUninstallAction)) continue;
                    retainedActions.add(autoUninstallAction);
                }
                catch (UserCanceledException e) {
                    return false;
                }
            }
            if (!processor.shouldWriteRetained(retainedActions)) continue;
            byte[] retainedBytes = AutoUninstallHandler.getPropertyFileBytes(retainedActions);
            if (retainedBytes != null) {
                FileInstaller.getInstance().addRetainedFile(autoUninstallFile);
                try {
                    FileOutputStream outputStream = new FileOutputStream(autoUninstallFile);
                    Throwable throwable = null;
                    try {
                        outputStream.write(retainedBytes);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outputStream == null) continue;
                        if (throwable != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    Logger.getInstance().log(e);
                }
                continue;
            }
            autoUninstallFile.delete();
        }
        return true;
    }

    public static class AutoUninstallIdentifier {
        private final Class<?> actionClass;
        private final Properties properties;

        public AutoUninstallIdentifier(Class<?> actionClass, Properties properties) {
            this.actionClass = actionClass;
            this.properties = properties;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoUninstallIdentifier that = (AutoUninstallIdentifier)o;
            return this.actionClass.equals(that.actionClass) && this.properties.equals(that.properties);
        }

        public int hashCode() {
            int result = this.actionClass.hashCode();
            result = 31 * result + this.properties.hashCode();
            return result;
        }
    }

    public static class UninstallerContextSham
    extends ContextIntProxy
    implements UninstallerContext {
        public UninstallerContextSham(ContextInt parentContext) {
            super(parentContext);
        }

        @Override
        public boolean isUninstallForUpgrade() {
            return false;
        }
    }

    public static interface AutoUninstallProcessor {
        public boolean handle(AutoUninstallAction var1) throws UserCanceledException;

        public boolean shouldWriteRetained(List<AutoUninstallAction> var1);
    }
}

