/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.jideoss.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class FlatJidePainter
extends BasicPainter {
    protected final int arc = UIManager.getInt("Button.arc");

    public static ThemePainter getInstance() {
        return new FlatJidePainter();
    }

    public void installDefaults() {
        if (this._bk0 == null) {
            this._bk0 = UIManager.getColor("Panel.background");
        }
        super.installDefaults();
    }

    protected void paintBackground(JComponent c, Graphics g, Rectangle rect, Color borderColor, Color background, int orientation) {
        if (c instanceof JideButton && ((JideButton)c).getButtonStyle() == 0 || c instanceof JideSplitButton && ((JideSplitButton)c).getButtonStyle() == 0) {
            Color oldColor = g.getColor();
            g.setColor(FlatUIUtils.deriveColor((Color)background, (Color)c.getBackground()));
            Object[] oldRenderingHints = FlatUIUtils.setRenderingHints((Graphics)g);
            float arc = UIScale.scale((float)this.arc);
            if (c instanceof JideSplitButton) {
                int height;
                boolean horizontal = ((JideSplitButton)c).getOrientation() == 0;
                int width = horizontal ? c.getWidth() : c.getHeight();
                int n = height = horizontal ? c.getHeight() : c.getWidth();
                if (!horizontal) {
                    g.translate(0, -1);
                }
                Shape oldClip = g.getClip();
                g.clipRect(rect.x, rect.y, rect.width, rect.height);
                FlatUIUtils.paintComponentBackground((Graphics2D)((Graphics2D)g), (int)0, (int)0, (int)width, (int)height, (float)0.0f, (float)arc);
                if (borderColor != null) {
                    g.setColor(borderColor);
                    FlatUIUtils.paintOutlinedComponent((Graphics2D)((Graphics2D)g), (int)0, (int)0, (int)width, (int)height, (float)0.0f, (float)0.0f, (float)0.0f, (float)UIScale.scale((float)1.0f), (float)arc, null, (Paint)borderColor, null);
                }
                g.setClip(oldClip);
                if (rect.x > 0) {
                    g.setColor(borderColor);
                    ((Graphics2D)g).fill(new Rectangle2D.Float(rect.x, rect.y, UIScale.scale((float)1.0f), rect.height));
                }
                if (!horizontal) {
                    g.translate(0, 1);
                }
            } else {
                FlatUIUtils.paintComponentBackground((Graphics2D)((Graphics2D)g), (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height, (float)0.0f, (float)arc);
                if (borderColor != null) {
                    g.setColor(borderColor);
                    FlatUIUtils.paintOutlinedComponent((Graphics2D)((Graphics2D)g), (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height, (float)0.0f, (float)0.0f, (float)0.0f, (float)UIScale.scale((float)1.0f), (float)arc, null, (Paint)borderColor, null);
                }
            }
            FlatUIUtils.resetRenderingHints((Graphics)g, (Object[])oldRenderingHints);
            g.setColor(oldColor);
        } else {
            super.paintBackground(c, g, rect, borderColor, background, orientation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintGripper(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        float userScaleFactor = UIScale.getUserScaleFactor();
        if (userScaleFactor > 1.0f) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.translate(rect.x, rect.y);
                g2.scale(userScaleFactor, userScaleFactor);
                Rectangle rect2 = new Rectangle(0, 0, UIScale.unscale((int)rect.width), UIScale.unscale((int)rect.height));
                super.paintGripper(c, (Graphics)g2, rect2, orientation, state);
            }
            finally {
                g2.dispose();
            }
        } else {
            super.paintGripper(c, g, rect, orientation, state);
        }
    }
}

