/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.UiUtil;
import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.PasswordDialog;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import com.install4j.runtime.installer.helper.content.HttpRequestHandler;
import com.install4j.runtime.installer.helper.content.UserNameAndPassword;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpAuthenticator
extends Authenticator {
    public static final String SYSPROP_PROXY_PASSWORD = "proxyAuthPassword";
    public static final String SYSPROP_PROXY_USER = "proxyAuthUser";
    public static final String SYSPROP_SERVER_AUTH_PASSWORD = "serverAuthPassword";
    public static final String SYSPROP_SERVER_AUTH_USER = "serverAuthUser";
    private static HttpAuthenticator authenticator;
    private static final boolean DEBUG;
    private HttpRequestHandler httpRequestHandler;
    private int currentConnection;
    private int lastAuthConnection;
    private boolean firstProxyAuthentication;
    private UserNameAndPassword lastProxyCredentials;
    private Map<String, UserNameAndPassword> lastServerCredentials = Collections.synchronizedMap(new HashMap());
    private boolean decoupled;

    public static synchronized HttpAuthenticator getInstance() {
        if (authenticator == null) {
            authenticator = new HttpAuthenticator();
        }
        return authenticator;
    }

    public static void setRequestHandler(HttpRequestHandler requestHandler) {
        if (DEBUG) {
            Util.logInfo(null, "HTTP request handler: " + requestHandler);
        }
        HttpAuthenticator instance = HttpAuthenticator.getInstance();
        instance.httpRequestHandler = requestHandler;
        ++instance.currentConnection;
    }

    public static UserNameAndPassword askForCredentialsGui(String header, String footer, String title, String installRegistryUserProperty) {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, context -> GUIHelper.invokeOnEDT(() -> {
            PasswordDialog inputDialog = PasswordDialog.createInputDialog(UiUtil.getParentWindow(), header, footer, title, null, true);
            if (installRegistryUserProperty != null) {
                inputDialog.setUser(InstallRegistry.getValue(installRegistryUserProperty));
            }
            inputDialog.setVisible(true);
            inputDialog.dispose();
            if (!inputDialog.isCanceled()) {
                if (installRegistryUserProperty != null) {
                    InstallRegistry.setValue(installRegistryUserProperty, inputDialog.getUser());
                }
                return new UserNameAndPassword(inputDialog.getUser(), inputDialog.getPassword());
            }
            throw new UserCanceledException();
        }));
    }

    public static UserNameAndPassword askForCredentialsConsole(AuthenticationType authenticationType, String requestingHost) {
        String credentialsMessage = authenticationType.getCredentialsMessage(requestingHost);
        String installRegistryUserProperty = authenticationType.getInstallRegistryUserProperty();
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, context -> {
            ConsoleImpl console = ConsoleImpl.getInstance();
            console.println(credentialsMessage);
            String userName = console.askString(Messages.getString(".UserName"), HttpAuthenticator.getSavedProxyUser(installRegistryUserProperty));
            HttpAuthenticator.saveProxyUser(userName, installRegistryUserProperty);
            String password = console.askPassword(Messages.getString(".Password"), "");
            return new UserNameAndPassword(userName, password);
        });
    }

    private static String getSavedProxyUser(String installRegistryUserProperty) {
        if (installRegistryUserProperty != null) {
            return InstallRegistry.getValue(installRegistryUserProperty);
        }
        return null;
    }

    private static void saveProxyUser(String userName, String installRegistryUserProperty) {
        if (installRegistryUserProperty != null) {
            InstallRegistry.setValue(installRegistryUserProperty, userName);
        }
    }

    public static UserNameAndPassword getProxyCredentialsFromOtherExecutionContext() {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.OTHER, context -> HttpAuthenticator.getInstance().getLastProxyCredentials());
    }

    public void clearCredentials() {
        this.lastProxyCredentials = null;
        this.lastServerCredentials.clear();
    }

    public void setDecoupled(boolean decoupled) {
        this.decoupled = decoupled;
    }

    public UserNameAndPassword getLastProxyCredentials() {
        return this.lastProxyCredentials;
    }

    public UserNameAndPassword getLastServerCredentials(String host) {
        return this.lastServerCredentials.get(host);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        UserNameAndPassword credentials;
        boolean proxy;
        if (this.httpRequestHandler == null && !this.decoupled) {
            if (DEBUG) {
                Util.logInfo(null, "No HTTP request handler");
            }
            return null;
        }
        AuthenticationType authenticationType = this.getAuthenticationType();
        boolean bl = proxy = authenticationType == AuthenticationType.PROXY;
        if (proxy && this.firstProxyAuthentication && HelperCommunication.getInstance().isConnected()) {
            this.firstProxyAuthentication = false;
            credentials = HttpAuthenticator.getProxyCredentialsFromOtherExecutionContext();
            if (credentials != null) {
                return credentials.toPasswordAuthentication();
            }
        }
        credentials = this.getPasswordAuthentication(authenticationType);
        if (proxy) {
            this.lastProxyCredentials = credentials;
        } else {
            this.lastServerCredentials.put(this.getRequestingHost(), credentials);
        }
        return credentials != null ? credentials.toPasswordAuthentication() : null;
    }

    @Nullable
    private UserNameAndPassword getPasswordAuthentication(AuthenticationType authenticationType) {
        String user;
        URL url = this.getRequestingURL();
        if (DEBUG) {
            authenticationType.debug(url);
            Util.logInfo(null, "lastAuthConnection: " + this.lastAuthConnection);
            Util.logInfo(null, "currentConnection: " + this.currentConnection);
        }
        if ((user = authenticationType.getUser(url)) != null && this.lastAuthConnection != this.currentConnection) {
            this.lastAuthConnection = this.currentConnection;
            String password = authenticationType.getPassword(url);
            return new UserNameAndPassword(user, password != null ? password : "");
        }
        if (this.decoupled || this.httpRequestHandler.getMode() == 1) {
            String header = authenticationType.getCredentialsMessage(this.getRequestingHost());
            return HttpAuthenticator.askForCredentialsGui(header, this.getRequestingPrompt(), Messages.getString(".EnterCredentialsTitle"), authenticationType.getInstallRegistryUserProperty());
        }
        if (this.httpRequestHandler.getMode() == 2) {
            return HttpAuthenticator.askForCredentialsConsole(authenticationType, this.getRequestingHost());
        }
        if (this.httpRequestHandler.getMode() == 3 && user == null) {
            System.err.println(authenticationType.getCommandLineParameterMessage());
        }
        return null;
    }

    private AuthenticationType getAuthenticationType() {
        if (this.getRequestorType() == Authenticator.RequestorType.SERVER) {
            return AuthenticationType.SERVER;
        }
        return AuthenticationType.PROXY;
    }

    static {
        DEBUG = Boolean.getBoolean("install4j.debugAuthentication");
    }

    protected static class PropertyNameAndValue {
        public final String name;
        public final String value;

        public PropertyNameAndValue(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public void debug() {
            if (this.name != null) {
                Util.logInfo(null, this.toString());
            }
        }

        public String toString() {
            return this.name + ": " + this.value;
        }
    }

    public static enum AuthenticationType {
        SERVER{

            @Override
            public PropertyNameAndValue getUserProperty(URL url) {
                return AuthenticationType.getProperty(HttpAuthenticator.SYSPROP_SERVER_AUTH_USER);
            }

            @Override
            public PropertyNameAndValue getPasswordProperty(URL url) {
                return AuthenticationType.getProperty(HttpAuthenticator.SYSPROP_SERVER_AUTH_PASSWORD);
            }

            @Override
            public String getCredentialsMessage(String requestingHost) {
                return Messages.format(Messages.getString(".EnterCredentialsLabel"), requestingHost);
            }

            @Override
            public String getCommandLineParameterMessage() {
                return Messages.getString(".ServerPasswordRequired");
            }

            @Override
            public String getInstallRegistryUserProperty() {
                return null;
            }
        }
        ,
        PROXY{

            @Override
            public PropertyNameAndValue getUserProperty(URL url) {
                return AuthenticationType.getProperty(HttpAuthenticator.SYSPROP_PROXY_USER);
            }

            @Override
            protected PropertyNameAndValue getPasswordProperty(URL url) {
                return AuthenticationType.getProperty(HttpAuthenticator.SYSPROP_PROXY_PASSWORD);
            }

            @Override
            public String getCredentialsMessage(String requestingHost) {
                return Messages.getString(".ProxyAuthentication");
            }

            @Override
            public String getCommandLineParameterMessage() {
                return Messages.getString(".ProxyPasswordRequired");
            }

            @Override
            public String getInstallRegistryUserProperty() {
                return HttpAuthenticator.SYSPROP_PROXY_USER;
            }
        };

        private static final PropertyNameAndValue NOT_FOUND;

        @NotNull
        private static PropertyNameAndValue getProperty(@NotNull String propertyName) {
            String propertyValue = HelperCommunication.getUnelevatedProperty(propertyName);
            if (propertyValue != null) {
                return new PropertyNameAndValue(propertyName, propertyValue);
            }
            return NOT_FOUND;
        }

        protected abstract PropertyNameAndValue getUserProperty(URL var1);

        protected abstract PropertyNameAndValue getPasswordProperty(URL var1);

        public abstract String getCredentialsMessage(@Nullable String var1);

        public abstract String getCommandLineParameterMessage();

        public abstract String getInstallRegistryUserProperty();

        public String getUser(URL url) {
            return this.getUserProperty((URL)url).value;
        }

        public String getPassword(URL url) {
            return this.getPasswordProperty((URL)url).value;
        }

        public void debug(URL url) {
            Util.logInfo(null, "Authentication type " + this.name());
            this.getUserProperty(url).debug();
            this.getPasswordProperty(url).debug();
        }

        static {
            NOT_FOUND = new PropertyNameAndValue(null, null);
        }
    }
}

