/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.AlignmentSupport;
import com.jidesoft.swing.ButtonStyle;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Cursor;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class JideButton
extends JButton
implements Alignable,
ButtonStyle,
ComponentStateSupport,
AlignmentSupport {
    private static final String uiClassID = "JideButtonUI";
    public static final String PROPERTY_ALWAYS_SHOW_HYPERLINK = "alwaysShowHyperlink";
    private boolean _alwaysShowHyperlink = false;
    private int _buttonStyle = 0;
    private Cursor _savedCursor;
    public static final String CLIENT_PROPERTY_HIDE_POPUPMENU = "JideButton.hidePopupMenu";
    private int _orientation;
    private Color _defaultForeground;
    private Color _rolloverBackground;
    private Color _selectedBackground;
    private Color _pressedBackground;
    private Color _rolloverForeground;
    private Color _selectedForeground;
    private Color _pressedForeground;

    public JideButton() {
        this(null, null);
    }

    public JideButton(Icon icon) {
        this(null, icon);
    }

    public JideButton(String string) {
        this(string, null);
    }

    public JideButton(Action action) {
        this();
        this.setAction(action);
    }

    public JideButton(String string, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(string, icon);
        this.setRolloverEnabled(true);
        this.setFocusable(true);
        this.setRequestFocusEnabled(false);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public int getOrientation() {
        return this._orientation;
    }

    @Override
    public void setOrientation(int n2) {
        if (this._orientation != n2) {
            int n3 = this._orientation;
            this._orientation = n2;
            this.firePropertyChange("orientation", n3, n2);
        }
    }

    @Override
    public boolean supportVerticalOrientation() {
        return true;
    }

    @Override
    public boolean supportHorizontalOrientation() {
        return true;
    }

    @Override
    public int getButtonStyle() {
        return this._buttonStyle;
    }

    @Override
    public void setButtonStyle(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Only TOOLBAR_STYLE, TOOLBOX_STYLE, FLAT_STYLE and HYPERLINK_STYLE are supported");
        }
        if (n2 == this._buttonStyle) {
            return;
        }
        int n3 = this._buttonStyle;
        this._buttonStyle = n2;
        this.configureCursor();
        this.firePropertyChange("buttonStyle", n3, this._buttonStyle);
    }

    private void configureCursor() {
        if (this.getButtonStyle() == 3 && this.isRolloverEnabled() && (this.getText() != null && this.getText().length() > 0 || this.getIcon() != null)) {
            this._savedCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (this._savedCursor != null) {
            this.setCursor(this._savedCursor);
            this._savedCursor = null;
        }
    }

    @Override
    public void setRolloverEnabled(boolean bl2) {
        super.setRolloverEnabled(bl2);
        this.configureCursor();
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.configureCursor();
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this.configureCursor();
    }

    public boolean isAlwaysShowHyperlink() {
        return this._alwaysShowHyperlink;
    }

    public void setAlwaysShowHyperlink(boolean bl2) {
        if (this._alwaysShowHyperlink != bl2) {
            boolean bl3 = this._alwaysShowHyperlink;
            this._alwaysShowHyperlink = bl2;
            this.firePropertyChange(PROPERTY_ALWAYS_SHOW_HYPERLINK, bl3, bl2);
        }
    }

    public Color getDefaultForeground() {
        return this._defaultForeground;
    }

    public void setDefaultForeground(Color color) {
        this._defaultForeground = color;
    }

    private Color getRolloverBackground() {
        return this._rolloverBackground;
    }

    private void setRolloverBackground(Color color) {
        this._rolloverBackground = color;
    }

    private Color getSelectedBackground() {
        return this._selectedBackground;
    }

    private void setSelectedBackground(Color color) {
        this._selectedBackground = color;
    }

    private Color getPressedBackground() {
        return this._pressedBackground;
    }

    private void setPressedBackground(Color color) {
        this._pressedBackground = color;
    }

    private Color getRolloverForeground() {
        return this._rolloverForeground;
    }

    private void setRolloverForeground(Color color) {
        this._rolloverForeground = color;
    }

    private Color getSelectedForeground() {
        return this._selectedForeground;
    }

    private void setSelectedForeground(Color color) {
        this._selectedForeground = color;
    }

    private Color getPressedForeground() {
        return this._pressedForeground;
    }

    private void setPressedForeground(Color color) {
        this._pressedForeground = color;
    }

    @Override
    public Color getBackgroundOfState(int n2) {
        switch (n2) {
            case 0: {
                return this.getBackground();
            }
            case 2: {
                return this.getRolloverBackground();
            }
            case 3: {
                return this.getSelectedBackground();
            }
            case 5: {
                Color color = this.getSelectedBackground();
                return color != null ? ColorUtils.toGrayscale(color) : color;
            }
            case 1: {
                return this.getPressedBackground();
            }
        }
        return null;
    }

    @Override
    public void setBackgroundOfState(int n2, Color color) {
        switch (n2) {
            case 0: {
                this.setBackground(color);
                break;
            }
            case 2: {
                this.setRolloverBackground(color);
                break;
            }
            case 3: {
                this.setSelectedBackground(color);
                break;
            }
            case 1: {
                this.setPressedBackground(color);
            }
        }
    }

    @Override
    public Color getForegroundOfState(int n2) {
        switch (n2) {
            case 0: {
                return this.getDefaultForeground();
            }
            case 2: {
                return this.getRolloverForeground();
            }
            case 3: {
                return this.getSelectedForeground();
            }
            case 1: {
                return this.getPressedForeground();
            }
        }
        return null;
    }

    @Override
    public void setForegroundOfState(int n2, Color color) {
        switch (n2) {
            case 0: {
                this.setDefaultForeground(color);
                break;
            }
            case 2: {
                this.setRolloverForeground(color);
                break;
            }
            case 3: {
                this.setSelectedForeground(color);
                break;
            }
            case 1: {
                this.setPressedForeground(color);
            }
        }
    }
}

