/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.substance;

import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.TableColumnGroup;
import com.jidesoft.plaf.basic.BasicNestedTableHeaderUIDelegate;
import com.jidesoft.plaf.substance.SubstanceCellStyleTableHeaderUIDelegate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceNestedTableHeaderUIDelegate
extends BasicNestedTableHeaderUIDelegate {
    public SubstanceNestedTableHeaderUIDelegate(JTableHeader jTableHeader, CellRendererPane cellRendererPane) {
        super(jTableHeader, cellRendererPane);
    }

    @Override
    protected void customizePaint(Graphics graphics, TableColumn tableColumn, Rectangle rectangle) {
        if (tableColumn instanceof TableColumnGroup) {
            SubstanceNestedTableHeaderUIDelegate.paintGrid(this._header, graphics, (TableColumnGroup)tableColumn, rectangle);
        } else {
            SubstanceCellStyleTableHeaderUIDelegate.paintGrid(this._header, graphics, tableColumn, rectangle);
        }
        super.customizePaint(graphics, tableColumn, rectangle);
    }

    static void paintGrid(JTableHeader jTableHeader, Graphics graphics, TableColumnGroup tableColumnGroup, Rectangle rectangle) {
        if (!(jTableHeader instanceof NestedTableHeader)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n2 = rectangle.y + rectangle.height;
        Color color = SubstanceCellStyleTableHeaderUIDelegate.getGridColor(jTableHeader);
        float f2 = SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)jTableHeader));
        graphics2D.setStroke(new BasicStroke(f2, 1, 2));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jTableHeader, (float)0.7f, (Graphics)graphics));
        graphics2D.drawLine(rectangle.x, (int)((float)n2 - f2 / 2.0f), rectangle.x + rectangle.width - 1, (int)((float)n2 - f2 / 2.0f));
        int n3 = ((NestedTableHeader)jTableHeader).originalColumnAtPoint(new Point(rectangle.x + 1, rectangle.y + 1));
        if (n3 >= 0 && n3 < jTableHeader.getColumnModel().getColumnCount()) {
            if (SubstanceCellStyleTableHeaderUIDelegate.hasLeadingVerticalGridLine(jTableHeader, rectangle, n3)) {
                graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x, n2);
            }
            if (SubstanceCellStyleTableHeaderUIDelegate.hasTrailingVerticalGridLine(jTableHeader, rectangle, n3)) {
                graphics2D.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, n2);
            }
        }
        graphics2D.dispose();
    }
}

