/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconUtils {
    public static Icon replaceIconColor(Icon icon, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        for (int i2 = 0; i2 < bufferedImage.getHeight(); ++i2) {
            for (int i3 = 0; i3 < bufferedImage.getWidth(); ++i3) {
                Color color3 = new Color(bufferedImage.getRGB(i3, i2), true);
                if (!IconUtils.colorMatches(color3, color)) continue;
                bufferedImage.setRGB(i3, i2, color2.getRGB());
            }
        }
        return new ImageIcon(bufferedImage);
    }

    private static boolean colorMatches(Color color, Color color2) {
        return color.getRGB() == color2.getRGB();
    }

    public static ImageIcon iconToImageIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        int n2 = icon.getIconWidth();
        int n3 = icon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return new ImageIcon(bufferedImage);
    }
}

