package com.install4j.api.beaninfo;


/**
 * Configuration class to set the default selection values of the possible answers for the "Ask user"
 * failure strategy when configuring actions in the install4j IDE.
 *
 * @see FailureStrategy#ASK_USER
 */
public class AskUserFailureDefaults {
    private final boolean askRetry;
    private final boolean askQuit;
    private final boolean askIgnore;

    /**
     * Construct a configuration object for the default selections in the IDE.
     *
     * @param askRetry  whether the "Ask whether to quit" option should be selected by default
     * @param askQuit   whether the "Ask whether to retry the action" option should be selected by default
     * @param askIgnore whether the "Ask whether to ignore the failure" option should be selected by default
     */
    public AskUserFailureDefaults(boolean askRetry, boolean askQuit, boolean askIgnore) {
        this.askIgnore = askIgnore;
        this.askQuit = askQuit;
        this.askRetry = askRetry;
    }

    /**
     * Returns if "Ask whether to retry the action" option should be selected by default.
     * @return {@code true} or {@code false}
     */
    public boolean isAskRetry() {
        return askRetry;
    }

    /**
     * Returns if the "Ask whether to quit" option should be selected by default.
     * @return {@code true} or {@code false}
     */
    public boolean isAskQuit() {
        return askQuit;
    }

    /**
     * Returns if "Ask whether to ignore the failure" option should be selected by default.
     * @return {@code true} or {@code false}
     */
    public boolean isAskIgnore() {
        return askIgnore;
    }
}
