package com.install4j.api.actions;

import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;

/**
 * All uninstall actions must implement this interface. You have to override all methods and provide a public constructor with no arguments.
 * It is recommended that you choose one of the derived abstract classes as a superclass.
 *
 * @author ej-technologies GmbH
 */
public interface UninstallAction extends Action {

    /**
     * This method is called by the framework to perform the action during uninstallation.
     * You can use the {@code ProgressInterface} available from {@code context.getProgressInterface()}
     * in order to display messages to the user or ask simple questions.
     * @param context the context of the uninstallation.
     * @return should return {@code true} if successful. If it returns {@code false}, the error message and the
     * failure strategy for the action configured in the install4j GUI will be used by the uninstaller.
     * @throws UserCanceledException You can let
     * these exceptions pass through, they will be handled by the framework.
     */
    boolean uninstall(UninstallerContext context) throws UserCanceledException;

}
