package com.install4j.api.actions;

import com.install4j.api.beans.Bean;
import com.install4j.api.context.Context;

import java.io.Serializable;

/**

 * The base interface for all actions. Do not implement this interface directly, only the derived interfaces are
 * functional. It is recommended that you choose one of the derived abstract classes as
 * a superclass. The life-cycle of actions is controlled by the framework.
 * @author ej-technologies GmbH
 */
public interface Action extends Bean, Serializable {
    /**
     * This method is called after the properties have been set
     * @param context the installation or uninstallation context
     */
    void init(Context context);
}
