package com.install4j.api;

import com.install4j.runtime.installer.helper.apiimpl.ServiceInfoImpl;

import java.io.File;

/**
 * Provides information about services created with install4j.
 */
public class ServiceInfo {

    /**
     * Checks if a service is running.
     * @param serviceFile the install4j service executable
     * @return true if it is running
     */
    public static boolean isServiceRunning(File serviceFile) {
        return ServiceInfoImpl.isServiceRunning(serviceFile);
    }

    /**
     * Checks if a service is installed on Windows.
     * @param serviceFile the install4j service executable
     * @return true if installed
     */
    public static boolean isServiceInstalled(File serviceFile) {
        return ServiceInfoImpl.isServiceInstalled(serviceFile);
    }
}
