/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.SimpleScrollPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.border.Border;

class SimpleScrollPaneLayout
extends ScrollPaneLayout {
    protected AbstractButton _scrollUp;
    protected AbstractButton _scrollDown;
    protected AbstractButton _scrollLeft;
    protected AbstractButton _scrollRight;

    SimpleScrollPaneLayout() {
    }

    @Override
    public void syncWithScrollPane(JScrollPane jScrollPane) {
        super.syncWithScrollPane(jScrollPane);
        if (jScrollPane instanceof SimpleScrollPane) {
            this._scrollUp = ((SimpleScrollPane)jScrollPane).getScrollUpButton();
            this._scrollDown = ((SimpleScrollPane)jScrollPane).getScrollDownButton();
            this._scrollLeft = ((SimpleScrollPane)jScrollPane).getScrollLeftButton();
            this._scrollRight = ((SimpleScrollPane)jScrollPane).getScrollRightButton();
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if ("SCROLL_UP_BUTTON".equals(string)) {
            this._scrollUp = (AbstractButton)this.addSingletonComponent(this._scrollUp, component);
        } else if ("SCROLL_DOWN_BUTTON".equals(string)) {
            this._scrollDown = (AbstractButton)this.addSingletonComponent(this._scrollDown, component);
        } else if ("SCROLL_LEFT_BUTTON".equals(string)) {
            this._scrollLeft = (AbstractButton)this.addSingletonComponent(this._scrollLeft, component);
        } else if ("SCROLL_RIGHT_BUTTON".equals(string)) {
            this._scrollRight = (AbstractButton)this.addSingletonComponent(this._scrollRight, component);
        } else {
            super.addLayoutComponent(string, component);
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (component == this._scrollUp) {
            this._scrollUp = null;
        } else if (component == this._scrollDown) {
            this._scrollDown = null;
        } else if (component == this._scrollLeft) {
            this._scrollLeft = null;
        } else if (component == this._scrollRight) {
            this._scrollRight = null;
        } else {
            super.removeLayoutComponent(component);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Insets insets = container.getInsets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        Dimension dimension = null;
        Dimension dimension2 = null;
        Component component = null;
        if (this.viewport != null) {
            dimension = this.viewport.getPreferredSize();
            dimension2 = this.viewport.getViewSize();
            component = this.viewport.getView();
        }
        if (dimension != null) {
            n2 += dimension.width;
            n3 += dimension.height;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            Insets insets2 = border.getBorderInsets(container);
            n2 += insets2.left + insets2.right;
            n3 += insets2.top + insets2.bottom;
        }
        if (this._scrollUp != null && this._scrollDown != null && this.vsbPolicy != 21) {
            if (this.vsbPolicy == 22) {
                n3 += this._scrollUp.isVisible() ? this._scrollUp.getPreferredSize().height : 0;
                n3 += this._scrollDown.isVisible() ? this._scrollDown.getPreferredSize().height : 0;
            } else if (dimension2 != null && dimension != null) {
                boolean bl2 = true;
                if (component instanceof Scrollable) {
                    boolean bl3 = bl2 = !((Scrollable)((Object)component)).getScrollableTracksViewportHeight();
                }
                if (bl2 && dimension2.height > dimension.height) {
                    n3 += this._scrollUp.isVisible() ? this._scrollUp.getPreferredSize().height : 0;
                    n3 += this._scrollDown.isVisible() ? this._scrollDown.getPreferredSize().height : 0;
                }
            }
        }
        if (this._scrollLeft != null && this._scrollRight != null && this.hsbPolicy != 31) {
            if (this.hsbPolicy == 32) {
                n2 += this._scrollLeft.isVisible() ? this._scrollLeft.getPreferredSize().width : 0;
                n2 += this._scrollRight.isVisible() ? this._scrollRight.getPreferredSize().width : 0;
            } else if (dimension2 != null && dimension != null) {
                boolean bl4 = true;
                if (component instanceof Scrollable) {
                    boolean bl5 = bl4 = !((Scrollable)((Object)component)).getScrollableTracksViewportWidth();
                }
                if (bl4 && dimension2.width > dimension.width) {
                    n2 += this._scrollLeft.isVisible() ? this._scrollLeft.getPreferredSize().width : 0;
                    n2 += this._scrollRight.isVisible() ? this._scrollRight.getPreferredSize().width : 0;
                }
            }
        }
        return new Dimension(n2, n3);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Cloneable cloneable;
        Object object;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Insets insets = container.getInsets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        if (this.viewport != null) {
            object = this.viewport.getMinimumSize();
            n2 += ((Dimension)object).width;
            n3 += ((Dimension)object).height;
        }
        if ((object = jScrollPane.getViewportBorder()) != null) {
            cloneable = object.getBorderInsets(container);
            n2 += cloneable.left + cloneable.right;
            n3 += cloneable.top + cloneable.bottom;
        }
        if (this._scrollUp != null && this._scrollDown != null && this.vsbPolicy != 21) {
            cloneable = new Dimension(Math.max(this._scrollUp.getMinimumSize().width, this._scrollDown.getMinimumSize().width), 0);
            ((Dimension)cloneable).height = ((Dimension)cloneable).height + (this._scrollUp.isVisible() ? this._scrollUp.getMinimumSize().height : 0);
            ((Dimension)cloneable).height = ((Dimension)cloneable).height + (this._scrollDown.isVisible() ? this._scrollDown.getMinimumSize().height : 0);
            n3 += ((Dimension)cloneable).height;
            n2 = Math.max(n2, ((Dimension)cloneable).width);
        }
        if (this._scrollLeft != null && this._scrollLeft != null && this.hsbPolicy != 31) {
            cloneable = new Dimension(0, Math.max(this._scrollLeft.getMinimumSize().height, this._scrollRight.getMinimumSize().height));
            ((Dimension)cloneable).width = ((Dimension)cloneable).width + (this._scrollLeft.isVisible() ? this._scrollLeft.getMinimumSize().width : 0);
            ((Dimension)cloneable).width = ((Dimension)cloneable).width + (this._scrollRight.isVisible() ? this._scrollRight.getMinimumSize().width : 0);
            n2 += ((Dimension)cloneable).width;
            n3 = Math.max(n3, ((Dimension)cloneable).height);
        }
        return new Dimension(n2, n3);
    }

    @Override
    public void layoutContainer(Container container) {
        boolean bl2;
        boolean bl3;
        Scrollable scrollable;
        boolean bl4;
        Insets insets;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Rectangle rectangle = jScrollPane.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        Insets insets2 = container.getInsets();
        rectangle.x = insets2.left;
        rectangle.y = insets2.top;
        rectangle.width -= insets2.left + insets2.right;
        rectangle.height -= insets2.top + insets2.bottom;
        Border border = jScrollPane.getViewportBorder();
        if (border != null) {
            insets = border.getBorderInsets(container);
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        } else {
            insets = new Insets(0, 0, 0, 0);
        }
        Component component = this.viewport != null ? this.viewport.getView() : null;
        Dimension dimension = component != null ? component.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension2 = this.viewport != null ? this.viewport.toViewCoordinates(rectangle.getSize()) : new Dimension(0, 0);
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = bl4 = rectangle.width < 0 || rectangle.height < 0;
        if (!bl4 && component instanceof Scrollable) {
            scrollable = (Scrollable)((Object)component);
            bl5 = scrollable.getScrollableTracksViewportWidth();
            bl6 = scrollable.getScrollableTracksViewportHeight();
        } else {
            scrollable = null;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, this._scrollUp.getPreferredSize().height);
        Rectangle rectangle3 = new Rectangle(0, 0, 0, this._scrollDown.getPreferredSize().height);
        if (bl4) {
            bl3 = false;
        } else if (this.vsbPolicy == 22) {
            bl3 = true;
        } else if (this.vsbPolicy == 21) {
            bl3 = false;
        } else {
            if (!this._scrollUp.isEnabled()) {
                rectangle2.height = 0;
            }
            if (!this._scrollDown.isEnabled()) {
                rectangle3.height = 0;
            }
            boolean bl8 = bl3 = !bl6 && dimension.height > dimension2.height;
        }
        if (this._scrollUp != null && this._scrollDown != null && bl3) {
            this.adjustForScrollUpAndDown(true, rectangle, rectangle2, rectangle3, insets);
            dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
        }
        Rectangle rectangle4 = new Rectangle(0, 0, this._scrollLeft.getPreferredSize().width, 0);
        Rectangle rectangle5 = new Rectangle(0, 0, this._scrollRight.getPreferredSize().width, 0);
        if (bl4) {
            bl2 = false;
        } else if (this.hsbPolicy == 32) {
            bl2 = true;
        } else if (this.hsbPolicy == 31) {
            bl2 = false;
        } else {
            if (!this._scrollLeft.isEnabled()) {
                rectangle4.width = 0;
            }
            if (!this._scrollRight.isEnabled()) {
                rectangle5.width = 0;
            }
            boolean bl9 = bl2 = !bl5 && dimension.width > dimension2.width;
        }
        if (this.hsb != null && bl2) {
            this.adjustForScrollLeftAndRight(true, rectangle, rectangle4, rectangle5, insets);
            if (this._scrollUp != null && this._scrollDown != null && !bl3 && this.vsbPolicy != 21) {
                dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
                boolean bl10 = bl3 = dimension.height > dimension2.height;
                if (bl3) {
                    this.adjustForScrollUpAndDown(true, rectangle, rectangle2, rectangle3, insets);
                }
            }
        }
        if (this.viewport != null) {
            this.viewport.setBounds(rectangle);
            if (scrollable != null) {
                boolean bl11;
                dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
                boolean bl12 = bl2;
                boolean bl13 = bl3;
                bl5 = scrollable.getScrollableTracksViewportWidth();
                bl6 = scrollable.getScrollableTracksViewportHeight();
                if (this.vsb != null && this.vsbPolicy == 20) {
                    boolean bl14 = bl11 = !bl6 && dimension.height > dimension2.height;
                    if (bl11 != bl3) {
                        bl3 = bl11;
                        this.adjustForScrollUpAndDown(bl3, rectangle, rectangle2, rectangle3, insets);
                        dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
                    }
                }
                if (this.hsb != null && this.hsbPolicy == 30) {
                    boolean bl15 = bl11 = !bl5 && dimension.width > dimension2.width;
                    if (bl11 != bl2) {
                        bl2 = bl11;
                        this.adjustForScrollLeftAndRight(bl2, rectangle, rectangle4, rectangle5, insets);
                        if (this.vsb != null && !bl3 && this.vsbPolicy != 21) {
                            dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
                            boolean bl16 = bl3 = dimension.height > dimension2.height;
                            if (bl3) {
                                this.adjustForScrollUpAndDown(true, rectangle, rectangle2, rectangle3, insets);
                            }
                        }
                    }
                }
                if (bl12 != bl2 || bl13 != bl3) {
                    this.viewport.setBounds(rectangle);
                }
            }
        }
        if (this._scrollUp != null && this._scrollDown != null) {
            if (bl3) {
                this._scrollUp.setVisible(true);
                this._scrollDown.setVisible(true);
                this._scrollUp.setBounds(rectangle2);
                this._scrollDown.setBounds(rectangle3);
            } else {
                this._scrollUp.setVisible(false);
                this._scrollDown.setVisible(false);
                this._scrollUp.setBounds(rectangle2.x, rectangle2.y, 0, 0);
                this._scrollDown.setBounds(rectangle3.x, rectangle3.y, 0, 0);
            }
        }
        if (this._scrollLeft != null && this._scrollRight != null) {
            if (bl2) {
                this._scrollLeft.setVisible(true);
                this._scrollRight.setVisible(true);
                this._scrollLeft.setBounds(rectangle4);
                this._scrollRight.setBounds(rectangle5);
            } else {
                this._scrollLeft.setVisible(false);
                this._scrollRight.setVisible(false);
                this._scrollLeft.setBounds(rectangle4.x, rectangle4.y, 0, 0);
                this._scrollRight.setBounds(rectangle5.x, rectangle5.y, 0, 0);
            }
        }
    }

    private void adjustForScrollUpAndDown(boolean bl2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Insets insets) {
        if (bl2) {
            int n2 = Math.max(0, Math.max(rectangle.width + insets.left + insets.right, Math.max(this._scrollUp.getPreferredSize().width, this._scrollDown.getPreferredSize().width)));
            rectangle.height -= rectangle2.height;
            rectangle.height -= rectangle3.height;
            rectangle2.width = n2;
            rectangle3.width = n2;
            rectangle2.x = rectangle.x - insets.left;
            rectangle3.x = rectangle.x - insets.left;
            rectangle2.y = rectangle.y - insets.top;
            rectangle.y += rectangle2.height;
            rectangle3.y = rectangle.y + rectangle.height + insets.bottom;
        }
    }

    private void adjustForScrollLeftAndRight(boolean bl2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Insets insets) {
        if (bl2) {
            int n2 = Math.max(0, Math.max(rectangle.height + insets.top + insets.bottom, Math.max(this._scrollLeft.getPreferredSize().height, this._scrollRight.getPreferredSize().height)));
            rectangle.width -= rectangle2.width;
            rectangle.width -= rectangle3.width;
            rectangle2.height = n2;
            rectangle3.height = n2;
            rectangle2.y = rectangle.y - insets.top;
            rectangle3.y = rectangle.y - insets.top;
            rectangle2.x = rectangle.x - insets.left;
            rectangle.x += rectangle2.width;
            rectangle3.x = rectangle.x + rectangle.width + insets.right;
        }
    }

    static class UIResource
    extends SimpleScrollPaneLayout
    implements javax.swing.plaf.UIResource {
        UIResource() {
        }
    }
}

