/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.vsnet.VsnetUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.sun.java.swing.plaf.windows.WindowsProgressBarUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;

public class VsnetWindowsProgressBarUI
extends WindowsProgressBarUI
implements ActionListener {
    private int repaintInterval;
    private int x = 0;
    private int y = 0;
    private int delta = 1;
    private Timer timer = null;
    private Rectangle boxRect;

    public static ComponentUI createUI(JComponent jComponent) {
        return new VsnetWindowsProgressBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.initRepaintInterval();
    }

    protected void startAnimationTimer() {
        if (this.timer == null) {
            this.timer = new Timer(this.getRepaintInterval() / 20, this);
        }
        this.y = 0;
        this.x = 0;
        this.delta = 1;
        this.timer.start();
    }

    protected void stopAnimationTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.x == 0) {
            this.delta = 1;
        } else if (this.x == this.progressBar.getWidth()) {
            this.delta = -1;
        }
        this.x += this.delta;
        this.progressBar.repaint();
    }

    protected int getRepaintInterval() {
        return this.repaintInterval;
    }

    private int initRepaintInterval() {
        this.repaintInterval = UIDefaultsLookup.getInt("ProgressBar.repaintInterval");
        return this.repaintInterval;
    }

    public void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        super.paintIndeterminate(graphics, jComponent);
        Color color = this.progressBar.getForeground();
        Color color2 = VsnetUtils.getLighterColor(color, 0.9f);
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        boolean bl2 = this.progressBar.getOrientation() == 1;
        Insets insets = this.progressBar.getInsets();
        insets.top = 2;
        insets.left = 2;
        insets.right = 2;
        insets.bottom = 2;
        int n2 = this.progressBar.getWidth() - (insets.right + insets.left);
        int n3 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        graphics.setColor(this.progressBar.getBackground());
        graphics.fillRect(insets.left, insets.top, n2, n3);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.delta > 0) {
            this.boxRect = new Rectangle(insets.left, insets.top, this.x, n3);
            JideSwingUtilities.fillNormalGradient(graphics2D, this.boxRect, color2, color, bl2);
        } else {
            this.boxRect = new Rectangle(this.x, insets.top, n2 - this.x, n3);
            JideSwingUtilities.fillNormalGradient(graphics2D, this.boxRect, color, color2, bl2);
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(graphics2D, insets.left, insets.top, n2, n3, this.boxRect.x, this.boxRect.width, insets);
            } else {
                this.paintString(graphics2D, insets.left, insets.top, n2, n3, this.boxRect.y, this.boxRect.height, insets);
            }
        }
    }

    private void paintString(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, Insets insets) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        String string = this.progressBar.getString();
        graphics2D.setFont(this.progressBar.getFont());
        Point point = this.getStringPlacement(graphics2D, string, n2, n3, n4, n5);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            graphics2D.setColor(this.getSelectionBackground());
            JideSwingUtilities.drawString(this.progressBar, graphics2D, string, point.x, point.y);
            graphics2D.setColor(this.getSelectionForeground());
            graphics2D.clipRect(n6, n3, n7, n5);
            JideSwingUtilities.drawString(this.progressBar, graphics2D, string, point.x, point.y);
        } else {
            graphics2D.setColor(this.getSelectionBackground());
            AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
            graphics2D.setFont(this.progressBar.getFont().deriveFont(affineTransform));
            point = this.getStringPlacement(graphics2D, string, n2, n3, n4, n5);
            JideSwingUtilities.drawString(this.progressBar, graphics2D, string, point.x, point.y);
            graphics2D.setColor(this.getSelectionForeground());
            graphics2D.clipRect(n2, n6, n4, n7);
            JideSwingUtilities.drawString(this.progressBar, graphics2D, string, point.x, point.y);
        }
        graphics2D.setClip(rectangle);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JProgressBar jProgressBar = new JProgressBar();
        JProgressBar jProgressBar2 = new JProgressBar();
        jProgressBar2.setUI((ProgressBarUI)((Object)new VsnetWindowsProgressBarUI()));
        jProgressBar.setIndeterminate(true);
        jProgressBar.setString("Percent");
        jProgressBar.setStringPainted(true);
        jProgressBar2.setIndeterminate(true);
        jProgressBar2.setString("Percent");
        jProgressBar2.setStringPainted(true);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)jProgressBar, "North");
        jPanel.add((Component)jProgressBar2, "South");
        JOptionPane.showMessageDialog(null, jPanel, "ProgressBars made intutive - santhosh@in.fiorano.com", 1);
        System.exit(0);
    }
}

